<?php
namespace Models;

class inpas_sbp {
	public $f3, $sets, $config;
	
	private $_rrn;

	function __construct($f3, $sets, $config) {
		$this->f3=$f3;
		$this->sets=$sets;
        $this->config=$config;
	}

	function send_cmd($cmd, $type=null, $sum=0) {
		if(!file_exists($this->config['DualConnectorPath'].$this->config['DualConnectorFile'])) {
			return array (
				'success'=>false,
				'status_code'=>'999',
				'status_txt'=>'Ошибка. Не найден исполняемый файл '.$this->config['DualConnectorPath'].$this->config['DualConnectorFile'],
				'txt'=>'Ошибка. Не найден исполняемый файл '.$this->config['DualConnectorPath'].$this->config['DualConnectorFile']
			);
		}

		if(file_exists($this->config['DualConnectorPath']."result.txt")) {
			unlink($this->config['DualConnectorPath']."result.txt");
		}
		if(file_exists($this->config['DualConnectorPath']."receipt.txt")) {
			unlink($this->config['DualConnectorPath']."receipt.txt");
		}
		
		$cmd .= " -z".$this->config['TerminalID'];
		$cmd=str_replace("\n", '', $cmd);
		$cmd=str_replace("\r", '', $cmd);
		
		exec("\"".$this->config['DualConnectorPath'].$this->config['DualConnectorFile']."\" ".$cmd."\"");
		
		if(!file_exists($this->config['DualConnectorPath']."result.txt")) {
			return array (
				'success'=>false,
				'status_code'=>'999',
				'status_txt'=>'Ошибка. Не найден файл результатов. Проверьте подключение терминала к компьютеру и не занят ли он чем-то. Перезагрузите терминал.',
				'txt'=>'Ошибка. Не найден файл результатов. Проверьте подключение терминала к компьютеру и не занят ли он чем-то. Перезагрузите терминал.'
			);
		}
		
		$cheq='';
		$success = false;
		$status_code = 0;
		$status_txt='';
		$pan='';
		$transid='';
		$authcode='';
		$lines=file($this->config['DualConnectorPath']."result.txt");
		foreach ($lines as $line) {
			$l=explode('=', $line);
			$l[0]=str_replace(' ', '', $l[0]);
			$l[0]=str_replace("'", '', $l[0]);
			$l[0]=trim($l[0]);

			$l[1]=str_replace(' ', '', $l[1]);
			$l[1]=str_replace("'", '', $l[1]);
			$l[1]=trim($l[1]);

			if($l[0]=='[10]') {
				$pan=$l[1];
			}

			if($l[0]=='[13]') {
				$authcode=$l[1];
			}

			if($l[0]=='[14]') {
				$transid=$l[1];
			}
			
			if($l[0]=='[19]') {
				$status_txt=$l[1];
			}

			if($l[0]=='[39]') {
				$status_code=$l[1];
				
				if((int) $l[1] === 1) {
					$success=true;
				}
				else if((int) $l[1] === 0) {					
					if($type) {
						$n=0;
						while($n++ < 3) {
							if($type=='sale') {
								$pres = $this->send_cmd("-o1 -a".($sum*100)." -c643 -53f117 -13f".$this->$_rrn);
							}
							else if($type=='return' || $type=='cancel') {
								$pres = $this->send_cmd("-o29 -a".($sum*100)." -c643 -53f119 -13f".$this->$_rrn);
							}
							
							if($pres['success']==true) {
								$success=true;
								break;
							}
							else if((int) $pres['status_code']!==0) {
								$success=false;
								$status_code=$pres['status_code'];
								$status_txt=$pres['status_txt'];
								break;
							}
							sleep(2);
						}
					}
				}
			}
		}
		
		if(file_exists($this->config['DualConnectorPath']."receipt.txt")) {
			$cheq=file_get_contents($this->config['DualConnectorPath']."receipt.txt");
		}
		
		if (!preg_match('//u', $cheq)) {
			$cheq=iconv("windows-1251","utf-8",$cheq);
		}
		$cheq=str_replace('~', '' , $cheq);

		if (!preg_match('//u', $status_txt)) {
			$status_txt=iconv("windows-1251","utf-8",$status_txt);
		}
		
		if($success) {
			$slips=explode('0xDA^^', $cheq);
			$slips[0]=str_replace('0xDF^^', '' , $slips[0]);
			if(!$slips[1]) {
				$slips[1]=$slips[0];
			}
			return array(
				'success'=>true,
				'txt'=>nl2br($slips[0]),
				'slip'=>nl2br($slips[1]),
				'pan'=>$pan,
				'transid'=>$transid,
				'authcode'=>$authcode
			);
		}
		
		return array(
			'success'=>false,
			'status_code'=>$status_code,
			'status_txt'=>$status_txt,
			'txt'=>nl2br($status_txt).'<br>Код статуса: '.$status_code
		);
	}

	function ticket($type, $sum, $return_bt=null) {
		$this->$_rrn = $this->config['TerminalID'].date('Ymdhis');
		
		if($type=='sale') {
			$cmd='-o1 -53f115';
		}
		else { //возврат
			$cmd='-o29 -53f118 -13f'.$return_bt['transid'];
		}
		$cmd.=" -a".($sum*100)." -c643 -14f".$this->$_rrn;
		return $this->send_cmd($cmd, $type, $sum);
	}

	function z($change) {
		if($this->config['dayClose']) {
			$cmd='-o59';
			return $this->send_cmd($cmd);
		}
		
		$cheq=$this->sets['title']."\nСмена успешно закрыта";
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}

	function x($change) {
		if($this->config['dayClose']) {
			$cmd='-o63 -m20';
			return $this->send_cmd($cmd);
		}		
		
		$cheq='';
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}

	function testconnection() {
		$cmd='-o26 -a10 -c643';
		return $this->send_cmd($cmd);
	}
}
