<?php
namespace Models;

// Модель Категорий товаров
class Productcategories extends \DB\SQL\Mapper {
	public $db, $f3;

	public function __construct($db, $f3) {
		parent::__construct($db, 'productcategories' ); // подключаемся к таблице категорий товаров
		$this->db=$db;
		$this->f3=$f3;
	}

	// данные о страницах
	function page_data($page='directory') {
		$pages=array(
			'directory'=>array(
				'title'=>'Справочник категорий номенклатуры',
				'inc'=>'productcategories_directory.htm'
			),
			'add'=>array(
				'title'=>'Добавить новую категорию номенклатуры',
				'inc'=>'productcategories_form.htm'
			),
			'change'=>array(
				'title'=>'Редактировать категорию номенклатуры',
				'inc'=>'productcategories_form.htm'
			)
		);
		$pages[$page]['page']=$page;

		return $pages[$page];
	}

	// Выбор из базы
	function select_productcategories($query=null, $options=null) {
		// Ищем только не удаленные категории
		if(is_array($query)) {
			$query[0]='('.$query[0].') AND date_delete=0';
		}
		else {
			$query[0]='date_delete=0';
		}
		$this->reset();
		$this->load($query, $options);
		$categories=array();
		if(!$this->dry()) {
			do {
				$categories[]=$this->cast();
			}
			while ($this->skip());
		}
		return $categories;
	}

	// Поиск родительских категорий
	function get_parents($id) {
		$parents=array();
		do {
			$this->reset();
			$this->load(array('id=?', $id), array('limit'=>1));
			if(!$this->dry()) {
				$parents[]=$this->cast();
				$id=$this->parent_id;
			}
		}
		while(!$this->dry() && $this->parent_id>0);
		return $parents;
	}

	// Список категорий, включая подкатегории
	function find_cat($parent, $depth, $order) {
		$cat=$this->db->exec("SELECT * FROM productcategories WHERE date_delete=0 AND parent_id=? ORDER BY ".$order, $parent);
		if(!empty($cat)) {
			foreach($cat as $k=>$c) {
				$c['depth']=$depth;
				$categories[]=$c;
				$sub=$this->find_cat($c['id'], $depth+1, $order);
				if(!empty($sub)) {
					foreach($sub as $s) {
						$categories[]=$s;
					}
				}
			}
		}
		return $categories;
	}

	function categories_list($parent=0, $order='title') {
		return $categories=$this->find_cat($parent, 0, $order);
	}

	function save_productcategories($data) {
		$this->reset();
		if(!$data['title']) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		if($data['id']) {
			/*if($data['id']==$this->f3->get('default_category')) {
				return array(
					'success'=>false,
					'txt'=>'default_productcategories_can_not_change'
				);
			}*/
			$this->load(array('id=?', $data['id']), array('limit'=>1));
			if($this->dry()) {
				return array(
					'success'=>false,
					'txt'=>'not_found'
				);
			}
			$res=$this->find(array('title=? AND id!=? AND date_delete=0 AND parent_id=?', array($data['title'], $data['id'], $data['parent_id'])), array('limit'=>1));
		}
		else {
			$res=$this->find(array('title=? AND date_delete=0 AND parent_id=?', array($data['title'], $data['parent_id'])), array('limit'=>1));
			$data['id']=$this->db->exec("SELECT MAX(id) AS max_id FROM productcategories")[0]['max_id']+1;
		}
		if($res) {
			return array(
				'success'=>false,
				'txt'=>'productcategories_is_exists'
			);
		}
		$data['date_delete']=0;
		$data['date_update']=microtime(true);
		$this->copyFrom($data);
		if($this->save()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>array('.productcategories'),
		);
	}

	function delete($id) {
		/*if($id==$this->f3->get('default_category')) {
			return array(
				'success'=>false,
				'txt'=>'default_productcategories_can_not_change'
			);
		}*/
		$this->reset();
		if(!$id) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$this->load(array('id=?', $id), array('limit'=>1));
		if($this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}
		$products=$this->db->exec("SELECT (COUNT(*)+(SELECT COUNT(*) FROM productcategories WHERE parent_id=? AND date_delete=0)) AS count FROM products WHERE category_id=? AND date_delete=0", array($id, $id));
		if($products[0]['count']>0) {
			return array(
				'success'=>false,
				'txt'=>'productcategories_can_not_delete'
			);
		}
		$this->date_delete=microtime(true);
		if($this->update()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>array('.productcategories'),
		);
	}
}
