<?php
namespace Models;

class alfabank_sbp {
	public $f3, $sets, $config, $web;
	
	function __construct($f3, $sets, $config) {
		$this->f3=$f3;
		$this->sets=$sets;
        $this->config=$config;
        $this->web=\Web::instance();
	}

	function get_authdata() {
		return array(
			'userName'=>$this->config['userName'],
			'password'=>$this->config['password'],
		);	
	}

	function create_cancel_qr($sum, $return_epay) {
		$val=$this->get_authdata();
		$val['orderId']=$return_epay['sbp_order_id'];
		$val['amount']=$sum;
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'content'=>$val
		);
		$url=$this->config['AlfaBankPath'].'/refund.do';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		if((int)$json['errorCode']==0) {
			$slip="Статус: Успешно\n";
			$slip.="Идентификатор операции\n";
			$slip.=' - в Банке: '.$return_epay['sbp_order_id']."\n";
			$slip.=' - в СБП: '.$return_epay['transid']."\n";
			return array(
				'success'=>true,
				'txt'=>nl2br($slip),
				'slip'=>nl2br($slip),
				'pan'=>'',
				'transid'=>$return_epay['transid'],
				'authcode'=>'',
			);
		}
		else {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['errorCode'].'. ' .$json['errorMessage']
			);
		}
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}
		return array(
			'success'=>false,
			'txt'=>'Неудается отправить запрос на создание QR-кода'
		);
	}

	function create_sale_qr($sum) {
		$receipt_id=$this->f3->get('COOKIE.receipt_id');
		$val=$this->get_authdata();
		$val['orderNumber']=$receipt_id;
		$val['amount']=$sum;
		$val['returnUrl']=$this->config['returnUrl'];
		$val['description']='Оплата по чеку '.$receipt_id;
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'content'=>$val
		);
		$url=$this->config['AlfaBankPath'].'/register.do';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		if((int)$json['errorCode']>0) {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['errorCode'].'. ' .$json['errorMessage']
			);
		}
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if($json['formUrl']) {
			$res=$this->create_qr($json['orderId'], $json['formUrl']);
			if(!$res['success']) {
				return $res;
			}
			return array(
				'success'=>true,
				'qr'=>$res['payload'],
				'qr_id'=>$res['qrId'],
				'sbp_order_id'=>$json['orderId'],
				'receipt_id'=>$receipt_id,
				'show_qr'=>'/receipts/show_qr?receipt_id='.$receipt_id.'&order_id='.$json['orderId'].'&qr_id='.$res['qrId'].'&epay='.$this->sets['id'].'&sum='.$sum.'&url='.urlencode($res['payload'])
			);
		}
		return array(
			'success'=>false,
			'txt'=>'Неудается отправить запрос на создание QR-кода'
		);
	}

	function create_qr($order_id, $url) {
		$val=$this->get_authdata();
		$val['mdOrder']=$order_id;
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'headers'=>array(
    			'Сontent-type: application/x-www-form-urlencoded'
    		),
    		'content'=>$val
		);
		$url=$this->config['AlfaBankPath'].'/sbp/c2b/qr/dynamic/get.do';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		if((int)$json['errorCode']>0) {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['errorCode'].'. ' .$json['errorMessage']
			);
		}
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if(mb_strtoupper($json['qrStatus'])=='STARTED') {
			return array(
				'success'=>true,
				'qrId'=>$json['qrId'],
				'payload'=>$json['payload']
			);
		}
		return array(
			'success'=>false,
			'txt'=>'Неудается отправить запрос на создание QR-кода. Статус '.$json['qrStatus']
		);
	}

	function ticket($type, $sum, $return_epay=null) {
		if($type=='sale') {
			return $this->create_sale_qr($sum*100);
		}
		return $this->create_cancel_qr($sum*100, $return_epay);

	}

	function paycontrol_qr($data) {
		$val=$this->get_authdata();
		$val['mdOrder']=$data['order_id'];
		$val['qrId']=$data['qr_id'];
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'headers'=>array(
    			'Сontent-type: application/x-www-form-urlencoded'
    		),
    		'content'=>$val
		);
		$url=$this->config['AlfaBankPath'].'/sbp/c2b/qr/status.do';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		if((int)$json['errorCode']>0) {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['errorCode'].'. ' .$json['errorMessage']
			);
		}
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		$status=array(
			'ACCEPTED'=>'Оплачено',
			'REJECTED'=>'Отменено',
			'REJECTED_BY_USER'=>'Отменено мерчантом'
		);
		if($json['qrStatus']=='ACCEPTED') {
			$slip='Статус: '.$status[$json['qrStatus']]."\n";
			$slip.="Идентификатор операции\n";
			$slip.=' - в Банке: '.$data['order_id']."\n";
			$slip.=' - в СБП: '.$data['qr_id']."\n";
			return array(
				'success'=>true,
				'txt'=>nl2br($slip),
				'slip'=>nl2br($slip),
				'pan'=>'',
				'transid'=>$data['qr_id'],
				'authcode'=>'',
			);
		}
		else {
			if($json['qrStatus']=='REJECTED' || $json['qrStatus']=='REJECTED_BY_USER') {
				return array(
					'success'=>false,
					'txt'=>'Статус платежа: '.$status[$json['qrStatus']],
					'show_error'=>true
				);
			}
			return array(
				'success'=>false,
				'txt'=>'Статус платежа: '.$json['qrStatus']
			);
		}

		return array(
			'success'=>false,
			'txt'=>'Неудается отправить запрос на создание QR-кода. Статус '.$json['qrStatus']
		);
	}

	function z($change) {
		$cheq=$this->sets['title']."\nСмена успешно закрыта";
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}

	function x($change) {
		$cheq='';
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}
}
