<?php
namespace Models;

class raiffayzen_sbp {
	public $f3, $sets, $config, $web;
	function __construct($f3, $sets, $config) {
		$this->f3=$f3;
		$this->sets=$sets;
        $this->config=$config;
        $this->web=\Web::instance();
	}

	function create_cancel_qr($sum, $return_epay) {
		$refundId=time();
		$val=array(
			'amount'=>$sum,
			'order'=>$return_epay['id'],
			'paymentDetails'=>'Возврат по чеку '.$return_epay['id'],
			'refundId'=>$refundId,
			'transactionId'=>$return_epay['transid']
		);
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'header'=>array(
    			'Content-Type: application/json',
    			'Authorization: Bearer '.$this->config['SecretKey']
    		),
    		'content'=>json_encode($val)
		);
		$url=$this->config['RaiffayzenBankPath'].'/api/sbp/v1/refund';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			if(isset($json['code'])) {
				return array (
					'success'=>false,
					'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
				);
			}
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if(isset($json['code']) && $json['code']!='SUCCESS') {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
			);
		}

		if($json['refundStatus']=='DECLINED') {
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		$stop=0;
		while ($stop<10) {
			$res=$this->refundcontrol($refundId);
			if($res['success'] || $res['show_error']) {
				$stop=10;
				return $res;
			}
			$stop++;
			sleep(2);
		}
		return array(
			'success'=>false,
			'txt'=>$res['body']
		);

	}

	function create_sale_qr($sum) {
		$receipt_id=$this->f3->get('COOKIE.receipt_id');
		$val=array(
			'qrType'=>'QRDynamic',
			'amount'=>$sum,
			'order'=>$receipt_id,
			'paymentDetails'=>'Оплата по чеку '.$receipt_id,
			'sbpMerchantId'=>$this->config['sbpMerchantId']
		);
		if(isset($this->config['account']) && $this->config['account']!='') {
			$val['account']=$this->config['account'];
		}
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'POST',
    		'header'=>array(
    			'Content-Type: application/json'
    		),
    		'content'=>json_encode($val)
		);
		$url=$this->config['RaiffayzenBankPath'].'/api/sbp/v2/qrs';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			if(isset($json['code'])) {
				return array (
					'success'=>false,
					'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
				);
			}
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if(isset($json['code']) && $json['code']!='SUCCESS') {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
			);
		}

		if($json['qrStatus']!='NEW') {
			return array (
				'success'=>false,
				'txt'=>'Не удается создать QR-код. Статус платежа: '.$json['qrStatus']
			);
		}

		if($json['payload']) {
			return array(
				'success'=>true,
				'qr'=>$json['payload'],
				'qr_id'=>$json['qrId'],
				'sbp_order_id'=>$json['qrId'],
				'receipt_id'=>$receipt_id,
				'show_qr'=>'/receipts/show_qr?receipt_id='.$receipt_id.'&order_id='.$json['qrId'].'&epay='.$this->sets['id'].'&sum='.($sum*100).'&url='.urlencode($json['payload'])
			);
		}
		return array(
			'success'=>false,
			'txt'=>'Не удается отправить запрос на создание QR-кода'
		);
	}

	function ticket($type, $sum, $return_epay=null) {
		$sum=round($sum, 2);
		if($type=='sale') {
			return $this->create_sale_qr($sum);
		}
		return $this->create_cancel_qr($sum, $return_epay);

	}

	function refundcontrol($id) {
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'GET',
    		'header'=>array(
    			'Content-Type: application/json',
    			'Authorization: Bearer '.$this->config['SecretKey']
    		)
		);
		$url=$this->config['RaiffayzenBankPath'].'/api/sbp/v1/refund/'.$id;
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			if(isset($json['code'])) {
				return array (
					'success'=>false,
					'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
				);
			}
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if(isset($json['code']) && $json['code']!='SUCCESS') {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message'],
				'show_error'=>true
			);
		}

		if($json['refundStatus']=='DECLINED') {
			return array (
				'success'=>false,
				'txt'=>'Платеж отклонен. Статус платежа: '.$json['refundStatus'],
				'show_error'=>true
			);
		}

		if($json['refundStatus']!='COMPLETED') {
			return array (
				'success'=>false,
				'txt'=>'Статус платежа: '.$json['refundStatus'],
			);
		}

		if($json['refundStatus']=='COMPLETED') {
			$slip="Статус: Успешно\n";
			$slip.="Идентификатор операции\n";
			$slip.=' - в Банке: '.$data['order_id']."\n";
			return array(
				'success'=>true,
				'txt'=>nl2br($slip),
				'slip'=>nl2br($slip),
				'pan'=>'',
				'transid'=>$id,
				'authcode'=>'',
			);
		}

		return array(
			'success'=>false,
			'txt'=>'Не удается узнать состояние платежа'
		);
	}

	function paycontrol_qr($data) {
		$options = array( // Данные для отправки на сервер
			'timeout'=>2,
    		'method'=>'GET',
    		'header'=>array(
    			'Content-Type: application/json',
    			'Authorization: Bearer '.$this->config['SecretKey']
    		)
		);
		$url=$this->config['RaiffayzenBankPath'].'/api/sbp/v1/qr/'.$data['order_id'].'/payment-info';
		$res=$this->web->request($url, $options);
		$json=json_decode($res['body'], true);
		
		if(mb_strpos($res['headers'][0], '200')===false && mb_strpos($res['headers'][0], '201')===false) {
			if(isset($json['code'])) {
				return array (
					'success'=>false,
					'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message']
				);
			}
			return array(
				'success'=>false,
				'txt'=>$res['body']
			);
		}

		if(isset($json['code']) && $json['code']!='SUCCESS') {
			return array (
				'success'=>false,
				'txt'=>'Код ошибки '.$json['code'].'. ' .$json['message'],
				'show_error'=>true
			);
		}

		if($json['paymentStatus']=='DECLINED') {
			return array (
				'success'=>false,
				'txt'=>'Платеж отклонен. Статус платежа: '.$json['paymentStatus'],
				'show_error'=>true
			);
		}

		if($json['paymentStatus']!='SUCCESS') {
			return array (
				'success'=>false,
				'txt'=>'Статус платежа: '.$json['paymentStatus'],
			);
		}

		if($json['paymentStatus']=='SUCCESS') {
			$slip="Статус: Успешно\n";
			$slip.="Идентификатор операции\n";
			$slip.=' - в Банке: '.$data['order_id']."\n";
			return array(
				'success'=>true,
				'txt'=>nl2br($slip),
				'slip'=>nl2br($slip),
				'pan'=>'',
				'transid'=>$json['transactionId'],
				'authcode'=>'',
			);
		}
		return array(
			'success'=>false,
			'txt'=>'Не удается узнать состояние платежа'
		);
	}

	function z($change) {
		$cheq=$this->sets['title']."\nСмена успешно закрыта";
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}

	function x($change) {
		$cheq='';
		return array(
			'success'=>true,
			'txt'=>nl2br($cheq),
			'slip'=>nl2br($cheq),
			'pan'=>0,
			'transid'=>0,
			'authcode'=>0
		);
	}
}
