function get_planstock(product_id) {
	if(product_id==0) return;
	$('div[for="'+product_id+'"]').html('<div class="donut"></div>');
	http_request=$.ajax({
        url: '/products/planstock?id='+product_id,
        dataType: "html",
        success: function(response) {
        	$('.planstock[for="'+product_id+'"]').html('-');
    		$('.min_limit[for="'+product_id+'"]').html('-');
        	try {
    			var res=JSON.parse(response);
    			if(res.success) {
    				var html='';
    				$.each(res.lines, function(n, line) {
    					html+='<p class="'+line.new+'">'+line.date+' - '+line.count+'</p>';
    					$('.planstock[for="'+product_id+'"]').html(html);
    				});
    				$('.min_limit[for="'+product_id+'"]').html(res.min_limit);
    			}
			} catch(e) {
    			console.log(response);
			}
    	},
    	error: function(response) {
    		$('div[for="'+product_id+'"]').html(response.statusText);
    	},
    	timeout: 3000
 	});
}

if($('.planstock').length>0) {
	get_planstock($('.planstock').attr('for'));
}

function add_stoplist_success(id) {
	$('.stop_list_product_'+id).toggleClass('stoplist');
	//$('.stop_list_product_'+id+' button').attr('disabled', true);
}
