<?php
namespace Controllers;
// Контроллер для товаров
class Productcategories extends Controller {

	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Productcategories($this->db, $this->f3);
	}

	function directory() {
		$productcategories=$this->model->categories_list(0, 'id');
		$this->f3->set('data', $productcategories);
		$this->f3->set('page_data', $this->model->page_data('directory'));
	}

	function form() {
		$id=$this->f3->get('GET.id');
		$data=array();
		$inc='add';
		if($id>0) {
			$data=$this->model->select_productcategories(array('id=?', $id), array('limit'=>1));
			if(!$data) {
				$this->f3->set('page_data', $this->messages->message('not_found'));
				return;
			}
			$inc='change';
		}
		$productcategories=$this->model->categories_list(0, 'id');
		$this->f3->set('productcategories', $productcategories);
		$this->f3->set('data', $data[0]);
		$this->f3->set('page_data', $this->model->page_data($inc));
	}

	function post_form() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_productcategories($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->model->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}
}