<?php
namespace Controllers;
// Контроллер Столы
class Tables extends Controller {

	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Tables($this->db, $this->f3); // модель столов
	}

	// Страница создания стола
	function add() {
		$inc='add';
		$keys=array(
			'room', 'x', 'y', 'id'
		);
		$data=array_combine($keys, explode('-', $this->f3->get('GET.data')));
		$table=array(
			array(
				'room'=>$data['room'],
				'x'=>$data['x'],
				'y'=>$data['y']
			)
		);
		if($data['id']) {
			$table=$this->model->select_tables(array('id=?', $data['id']), array('limit'=>1));
			if(!empty($table)) {
				$inc='change';
			}
		}
		$this->f3->set('table', $table[0]);
		$this->f3->set('page_data', $this->model->page_data($inc));
	}
	
	// Сохранение стола
	function post_add() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_table($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	// Удаление стола
	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->model->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}
}
