<?php
namespace Models;

class csv {
	public $f3, $sets, $config;
    public $params=array(
        1=>"plu",
        2=>"title",
        3=>"title1",
        4=>"title2",
        5=>"price",
        6=>"expiration_date",
        7=>"pack",
        8=>"group_code",
        9=>"barcode",
        10=>"message",
        11=>"img",
        12=>"rostest_code",
        13=>"implementation_date",
        14=>"type_products",
        15=>"barcode_structure",
        16=>"ticket_format",
        17=>"pr_type",
        18=>"date_manufacture"
    );
	
	function __construct($f3, $sets, $config) {
		$this->f3=$f3;
		$this->sets=$sets;
        if($config['path']!='' && mb_substr($config['path'], -1, 1)!='/') {
            $config['path'].='/';
        }
        if($config['path']!='' && mb_substr($config['path'], 0, 1)=='/') {
            $config['path']=$this->f3->get('ROOT').'/'.$config['path'];
        }
		$this->config=$config;
	}

    public function getScaleInfo() {
        return array(
            'serialNumber'=>0
        );
    }

    // Формируем содержимое файла
    function get_csv($products) {
        if($this->config['path']!='') {
            $this->config['path']=str_replace('\\', '/', $this->config['path']);
            $folders=explode('/', $this->config['path']);
            $path='';
            foreach($folders as $f) {
                if($f=='') continue;
                if(!file_exists($path.$f)) {
                    mkdir($path.$f);
                    chmod($path.$f, 0775);
                }
                $path=$path.$f.'/';
            }
        }
        $data=array(
            'messages'=>array(),
            'products'=>array(),
            'images'=>array(),
            'time'=>0
        );
        foreach($products as $p) {
            if($p['date_delete']>0) continue;
            for($i=1; $i<=16; $i++) {
                if(!isset($this->params[$this->config['param'.$i]])) continue;
                $param=$this->params[$this->config['param'.$i]];
                if($param=='price') {
                    $price=$p['price'];
                    if($p['vat_type']>0) {
                        $price-=$price/(100+$p['vat'])*$p['vat'];
                    }
                    $price=round($price, 2);
                    $p['price']=number_format($price, 2, '.', '');
                }
                elseif($param=='implementation_date') {
                    $p['implementation_date']='--.--.--';
                }
                elseif($param=='date_manufacture') {
                    $p['date_manufacture']='--.--.--';
                }
                elseif($param=='group_code') {
                    $p['group_code']=mb_substr($p['barcode']??'00', 0, 2);
                }
                elseif($param=='barcode') {
                    $p['barcode']=mb_substr($p['barcode']??'00000', 2);
                }
                elseif($param=='img') {
                    if($p['img']!='') {
                        $img=json_decode($p['img']);
                        if(is_array($img)) {
                            $img=array_shift($img);
                            $file_info=pathinfo($img);
                            $img_file=$this->config['path'].$p['plu'].'.'.$file_info['extension'];
                            $res=$this->f3->write($img_file, $this->f3->read('https://'.$this->config['api_data']['domen'].'/upload/'.$this->config['api_data']['subdomen'].'/250_250/'.$img));
                            if($res) {
                                for($img_i=1; $img_i<=2; $img_i++) {
                                    if($this->config['img_param'.$img_i]=='number') {
                                        $data['images'][$p['id']][]=$p['plu'];
                                    }
                                    elseif($this->config['img_param'.$img_i]=='path') {
                                        $data['images'][$p['id']][]=$img_file;
                                    }
                                }
                            }
                        }
                    }
                    $p['img']=1;
                }
                elseif($param=='message') {
                    $p['message'] = null;
                    $other_data=json_decode($p['other_data'], true);
                    if(is_array($other_data) && isset($other_data['compound']) && $other_data['compound']!='') {
                        $message='Состав: '.$other_data['compound'].". ";
                        if(isset($other_data['kkal']) && $other_data['kkal']>0) {
                            $message.="Ккал: ".$other_data['kkal'].'; ';
                        }
                        if(isset($other_data['proteins']) && $other_data['proteins']>0) {
                            $message.="Белки: ".$other_data['proteins'].'; ';
                        }
                        if(isset($other_data['fats']) && $other_data['fats']>0) {
                            $message.="Жиры: ".$other_data['fats'].'; ';
                        }
                        if(isset($other_data['carbohydrates']) && $other_data['carbohydrates']>0) {
                            $message.="Углеводы: ".$other_data['carbohydrates'].'; ';
                        }
                        for($messages_i=1; $messages_i<=2; $messages_i++) {
                            if($this->config['img_param'.$messages_i]=='number') {
                                $data['messages'][$p['id']][]=$p['id'];
                            }
                            elseif($this->config['img_param'.$messages_i]=='path') {
                                $data['messages'][$p['id']][]=$message;
                            }
                        }
                        $p['message'] = $p['id'];
                    }
                }
                elseif($param=='title1') {
                    $p['title1']=mb_substr($p['title'], 0, 40);
                }
                elseif($param=='title2') {
                    $p['title2']=mb_substr($p['title'], 40, 40);
                }
                $value=isset($p[$param])?$p[$param]:0;
                if($this->config['charset']!='utf-8') {
                    $value=iconv('utf-8', $this->config['charset'], $value);
                }
                $data['products'][$p['id']][]=$value;
            }
            
            $data['time']=0;
        }

        return $data;
    }

    function delete_products() {
        return $this->add_products(array(), 0, 0);
    }

    function add_products($products, $device, $exportType) {
        $data=$this->get_csv($products);
        // Создаем файл с товарами
        $fp=fopen($this->config['path'].$this->config['fileName'], 'w');
        $error='';
        if($fp) {
            if($data['products']) {
                foreach($data['products'] as $p) {
                    if(empty($p)) continue;
                    if(!fputcsv($fp, $p, $this->config['delimeter'], '"', '"')) {
                        $error.='Не удалось добавить строку в файл товаров<br>';
                    }
                }
            }
            fclose($fp);
        }
        else {
            return array(
                'success'=>false,
                'txt'=>'Не удалось создать файл с товарами'
            );
        }

        if($this->config['img_fileName']!='') {
            // Создаем файл с картинками
            $fp=fopen($this->config['path'].$this->config['img_fileName'], 'w');
            if($fp) {
                if($data['images']) {
                    foreach($data['images'] as $i) {
                        if(empty($i)) continue;
                        if(!fputcsv($fp, $i, $this->config['delimeter'], '"', '"')) {
                            $error.='Не удалось добавить строку в файл с фотографиями товаров<br>';
                        }
                    }
                }
                fclose($fp);
            }
            else {
                $error.='Не удалось создать файл с фотографиями товаров<br>';
            }
        }

        if($this->config['messages_fileName']!='') {
            // Создаем файл с описаниями
            $fp=fopen($this->config['path'].$this->config['messages_fileName'], 'w');
            if($fp) {
                if($data['messages']) {
                    foreach($data['messages'] as $m) {
                        if(empty($m)) continue;
                        if(!fputcsv($fp, $m, $this->config['delimeter'], '"', '"')) {
                            $error.='Не удалось добавить строку в файл с описаниями товаров<br>';
                        }
                    }
                }
                fclose($fp);
            }
            else {
                $error.='Не удалось создать файл с описаниями товаров<br>';
            }
        }

        return array(
            'success'=>$error==''?true:false,
            'txt'=>$error==''?'Успешно сохранено':$error,
            'time'=>$data['time']
        );
    }
}
