<?php
namespace Models;

class inpas_dcservice_sbp {
  public $f3, $sets, $config;
  private $_rrn;
  public $errors=array(
    -1=>'Неизвестная ошибка',
    0=>'DC не смог передать ответ от терминала. Возможная причина, внутренняя ошибка DC',
    1=>'Истекло время исполнения операции. Устанавливаемое полем «timeout» в запросе',
    3=>'Общая ошибка, ошибка параметров DC, не поддерживаемый метод HTTP,
неизвестная ошибка, ошибка во время работы DC',
    4=>'Ошибка поля или ошибка запроса, как между кассой и DC, так и между DC и
терминалом',
    13=>'Ошибка обмена данными между DC и терминалом. Возможная причина в отсутствии
устройства или ответ не по протоколу SA',
    15=>'Обмен данными прерван, например, выключение DC, мониторинг подключения
устройства или отменен другим обменом',
    16=>'Устройство занято, например, занято другим обменом'
  );

  function __construct($f3, $sets, $config) {
    $this->f3=$f3;
    $this->sets=$sets;
    if(!$config['URL']) $config['URL']='http://localhost:9015';
    $this->config=$config;
  }


  // Отправка задания
  function send_cmd($xml, $ok_field=39, $type=null, $sum=0) {
    $url=$this->config['URL'].'/requests';
    $headers=array(
      'Accept: text/xml',
      'Accept-Encoding: identity',
      'Content-Type: text/xml; charset=windows-1251'
    );
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL,$url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_POST,true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, iconv('utf-8', 'windows-1251//IGNORE', $xml));
    $data = curl_exec($curl);
    curl_close($curl);

    if(!$data) {
      return array(
        'success'=>false,
        'status_code'=>999,
        'status_txt'=>'Нет ответа от терминала',
        'txt'=>'Нет ответа от терминала'
      );
    }

    $data=str_replace('windows-1251', 'utf-8', $data);
    $data=iconv('windows-1251', 'utf-8', $data);

    $xml=new \SimpleXMLElement($data);

    if(!$xml) {
      return array(
        'success'=>false,
        'status_code'=>998,
        'status_txt'=>'Невалидный формат ответа',
        'txt'=>$data
      );
    }

    if(isset($xml->errorcode)) {
      if(isset($this->errors[(int)$xml->errorcode])) {
        $error=$this->errors[(int)$xml->errorcode];
      }
      else {
        $error=$this->errors[-1];
      }
      return array(
        'success'=>false,
        'status_code'=>$xml->errorcode,
        'status_txt'=>$error,
        'txt'=>$error
      );
    }

    foreach ($xml->field as $key => $field) {
      $field['id']=(int)$field['id'];
      if($field['id']==10) {
        $pan=trim($field);
      }

      if($field['id']==13) {
        $authcode=trim($field);
      }

      if($field['id']==14) {
        $transid=trim($field);
      }

      if($field['id']==19) {
        $status_txt=trim($field);
      }

      if($field['id']==$ok_field) {
        if((int)trim($field)===1) {
          $success=true;
        }
        else if((int)trim($field)===0) {
            $status_code=trim($field);					
			if($type) {
				$n=0;
				while($n++ < 3) {
					sleep(2);
					/*
					if($type=='sale') {
						//$pres = $this->send_cmd("-o1 -a".($sum*100)." -c643 -53f117 -13f".$this->$_rrn);
					}
					else if($type=='return' || $type=='cancel') {
						//$pres = $this->send_cmd("-o29 -a".($sum*100)." -c643 -53f119 -13f".$this->$_rrn);
					}
					*/
					
	$xml2="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml2.="<request>\n";
    $xml2.="<field id=\"00\">".($sum*100)."</field>\n";
    $xml2.="<field id=\"04\">643</field>\n";
    $xml2.="<field id=\"13\">".$this->$_rrn."</field>\n";
    
    if($type=='sale') {
	  $xml2.="<field id=\"25\">1</field>\n";
	  $xml2.="<field id=\"53\">117</field>\n";
    }
    else {
	  $xml2.="<field id=\"25\">29</field>\n";
	  $xml2.="<field id=\"53\">119</field>\n";
    }
    $xml2.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    $xml2.="</request>\n";
    $pres = $this->send_cmd($xml2);
					
					if($pres['success']==true) {
						$success=true;
						break;
					}
					else if((int) $pres['status_code']!==0) {
						$success=false;
						$status_code=$pres['status_code'];
						$status_txt=$pres['status_txt'];
						break;
					}
				}
			}
		}
        else {
          $success=false;
          $status_code=trim($field);
        }
      }

      if($field['id']==90) {
        if (!preg_match('//u', $field)) {
          $field=iconv("windows-1251","utf-8",$field);
        }
        $slips=explode('0xDA^^', $field);
        $slips[0]=str_replace('0xDF^^', '' , $slips[0]);
        if(!$slips[1]) {
          $slips[1]=$slips[0];
        }
      }
    }

    if($success) {
      return array(
        'success'=>true,
        'txt'=>nl2br($slips[0]),
        'slip'=>nl2br($slips[1]),
        'pan'=>$pan,
        'transid'=>$transid,
        'authcode'=>$authcode
      );
    }
    else {
      return array(
        'success'=>false,
        'status_code'=>$status_code,
        'status_txt'=>$status_txt,
        'txt'=>nl2br($status_txt).'<br>Код статуса: '.$status_code
      );
    }
  }

  function ticket($type, $sum, $return_bt=null) {
	$this->$_rrn = $this->config['TerminalID'].date('Ymdhis');

    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"00\">".($sum*100)."</field>\n";
    $xml.="<field id=\"04\">643</field>\n";
    $xml.="<field id=\"14\">".$this->$_rrn."</field>\n";
    
    if($type=='sale') {
	  $xml.="<field id=\"25\">1</field>\n";
	  $xml.="<field id=\"53\">115</field>\n";
    }
    else {
	  $xml.="<field id=\"25\">29</field>\n";
	  $xml.="<field id=\"53\">118</field>\n";
      $xml.="<field id=\"13\">".$return_bt['transid']."</field>\n";
    }
    $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    $xml.="</request>\n";
    return $this->send_cmd($xml, 39, $type, $sum);
  }

  function z($change) {
	if($this->config['dayClose']) {
		$xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
		$xml.="<request>\n";
		$xml.="<field id=\"25\">59</field>\n";
		$xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
		$xml.="</request>\n";
		return $this->send_cmd($xml);
	}
	
	$cheq=$this->sets['title']."\nСмена успешно закрыта";
	return array(
		'success'=>true,
		'txt'=>nl2br($cheq),
		'slip'=>nl2br($cheq),
		'pan'=>0,
		'transid'=>0,
		'authcode'=>0
	);
  }

  function x($change) {
	if($this->config['dayClose']) {
		$xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
		$xml.="<request>\n";
		$xml.="<field id=\"25\">63</field>\n";
		$xml.="<field id=\"65\">20</field>\n";
		$xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
		$xml.="</request>\n";
		return $this->send_cmd($xml, 67);
	}
	
	$cheq='';
	return array(
		'success'=>true,
		'txt'=>nl2br($cheq),
		'slip'=>nl2br($cheq),
		'pan'=>0,
		'transid'=>0,
		'authcode'=>0
	);
  }

  function testconnection() {
    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"25\">26</field>\n";
    $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    $xml.="</request>\n";
    return $this->send_cmd($xml);
  }
}
