// Показывать или нет поля для настройки программы, связанные с маркировкой
$('body').off('change', 'form select[name="check_mark"]');
$('body').on('change', 'form select[name="check_mark"]', function(){
	if($(this).val()>0) {
		$('tr.mark_settings').show();
	}
	else {
		$('tr.mark_settings').hide();
	}
});

// Показывать или нет поля для настройки программы, связанные с ЕГАИС
$('body').off('change', 'form select[name="egais"]');
$('body').on('change', 'form select[name="egais"]', function(){
	if($(this).val()>0) {
		$('tr.egais_settings').show();
	}
	else {
		$('tr.egais_settings').hide();
	}
});

// Показывать или нет поля для настройки программы, связанные с режимом совместной работы
$('body').off('change', 'form select[name="multikassa"]');
$('body').on('change', 'form select[name="multikassa"]', function(){
	if($(this).val()>0) {
		$('tr.multikassa_settings').show();
	}
	else {
		$('tr.multikassa_settings').hide();
	}
});

// Показывать или нет поля для настройки ККМ
$('body').off('change', 'form select[name="active"]');
$('body').on('change', 'form select[name="active"]', function(){
	var form=$(this).closest('form');
	if($(this).val()==1) {
		$('tr.active', form).show();
	}
	else {
		$('tr.active', form).hide();
	}
});

$('body').off('change', 'form select[name="pricechecker_speek"]');
$('body').on('change', 'form select[name="pricechecker_speek"]', function(){
	if($(this).val()==1) {
		$('tr.pricechecker_speek').show();
	}
	else {
		$('tr.pricechecker_speek').hide();
	}
});

$('body').off('change', 'form select[name="bt_active"]');
$('body').on('change', 'form select[name="bt_active"]', function(){
	if($(this).val()==1) {
		$('tr.bt_active').show();
	}
	else {
		$('tr.bt_active').hide();
	}
});

// Показывать или нет поля для настройки ФР
$('body').off('change', 'form select[name="type"]');
$('body').on('change', 'form select[name="type"]', function(){
	if($(this).val()==1) {
		$('tr.kkm_type').show();
	}
	else {
		$('tr.kkm_type').hide();
	}
});

// Снять или поставить пометку о прочтении в логах синхронизации
$('input[name="read_log"]').change(function(){
	var log_id=$(this).attr('for');
	send_form($('form[name="read_log_form_'+log_id));
});

// Пометить все логи как прочитанные
$('input[name="read_all_logs"]').click(function(){
	$('input[name="read_log"]').prop('checked', true);
	load_ajax('/settings/read_all_logs');
});

// Установка налогов
function set_vat(vat) {
	for(var i=0; i<6; i++) {
		$('input[name="vat['+i+']"]').val(vat[i]);
	}
}

// Настроить налоги как в Нева
$('body').off('click', 'input[name="neva_type"]');
$('body').on('click', 'input[name="neva_type"]', function(){
	var vat=[6,5,4,2,3,1];
	set_vat(vat);
});

// Настроить налоги как в АТОЛ
$('body').off('click', 'input[name="atol_type"]');
$('body').on('click', 'input[name="atol_type"]', function(){
	var vat=[4,1,5,2,6,3];
	set_vat(vat);
});

// Настроить налоги как в Штрих-М
$('body').off('click', 'input[name="shtrihm_type"]');
$('body').on('click', 'input[name="shtrihm_type"]', function(){
	var vat=[4,3,6,2,5,1];
	set_vat(vat);
});

// Настроить налоги как в Меркурий
$('body').off('click', 'input[name="mercury_type"]');
$('body').on('click', 'input[name="mercury_type"]', function(){
	var vat=[6,5,4,2,3,1];
	set_vat(vat);
});

// Настроить налоги как в MSPOS
$('body').off('click', 'input[name="mspos_type"]');
$('body').on('click', 'input[name="mspos_type"]', function(){
	var vat=[6,5,4,2,3,1];
	set_vat(vat);
});

// Отображение ссылки на настройку драйвера
var KKMurl=new Map();
if($('select[name="driver"]').length>0) {
	$('body').off('change, keyup', 'input[name="url"]');
	$('body').on('change, keyup', 'input[name="url"]', function(){
		KKMurl.set($('select[name="driver"]').val(), $('input[name="url"]').val());
	});
	KKMurl.set($('select[name="driver"]').val(), $('input[name="url"]').val());
}
$('body').off('change', 'select[name="driver"]');
$('body').on('change', 'select[name="driver"]', function(){
	var path=$(this).val();
	var device=$('input[name="device"]').val();
	if(path!='') {
		if(device!='') {
			device='&device='+device;
		}
		$('#driver_settings').attr('href', '/settings/drivers?path='+path+device);
		$('#driver_settings').removeClass('hide');

		var url=$('select[name="driver"] option:selected').attr('data-url');
		if(url!='') {
			if(!KKMurl.has(path)) {
				KKMurl.set(path, url);
			}
			$('input[name="url"]').val(KKMurl.get(path));
		}
	}
	else {
		$('#driver_settings').attr('href', '');
		$('#driver_settings').addClass('hide');
	}
});

// Отображение ссылки на настройку драйвера
$('body').off('change', 'select[name="bt_driver"]');
$('body').on('change', 'select[name="bt_driver"]', function(){
	var path=$(this).val();
	if(path!='') {
		$('#driver_settings').attr('href', '/settings/drivers?path='+path);
		$('#driver_settings').removeClass('hide');
	}
	else {
		$('#driver_settings').attr('href', '');
		$('#driver_settings').addClass('hide');
	}
});

// Отображение ссылки на настройку драйвера ТС ПИОТ
$('body').off('change', 'select[name="piot_driver"]');
$('body').on('change', 'select[name="piot_driver"]', function(){
	var path=$(this).val();
	if(path!='') {
		$('#driver_settings').attr('href', '/settings/drivers?device=piot&path='+path);
		$('.piot_driver_active').removeClass('hide');
	}
	else {
		$('#driver_settings').attr('href', '');
		$('.piot_driver_active').addClass('hide');
	}
});

if($('select[name="print_group_driver"]').length>0) {
	$('body').off('change, keyup', 'input[name="url"]');
	$('body').on('change, keyup', 'input[name="url"]', function(){
		var form=$(this).closest('form');
		KKMurl.set($('select[name="print_group_driver"]', form).val()+$(form).attr('id'), $('input[name="url"]', form).val());
	});
	//KKMurl.set($('select[name="print_group_driver"]', form).val()+$(form).attr('id'), $('input[name="url"]', form).val());
}

$('body').off('change', 'select[name="print_group_driver"]');
$('body').on('change', 'select[name="print_group_driver"]', function(){
	var form=$(this).closest('form');
	var path=$(this).val();
	if(path!='') {
		$('.print_group_driver_settings', form).attr('href', '/settings/drivers?path='+path+'&device='+$('input[name="device"]').val()+'&print_group_id='+$('input[name="print_group_id"]', form).val());
		$('.print_group_driver_settings', form).removeClass('hide');
	}
	else {
		$('.print_group_driver_settings', form).attr('href', '');
		$('.print_group_driver_settings', form).addClass('hide');
	}
	var url=$('select[name="print_group_driver"] option:selected', form).attr('data-url');
	if(url!='') {
		var form_id=$(form).attr('id');
		if(!KKMurl.has(path+form_id)) {
			KKMurl.set(path+form_id, url);
		}
		$('input[name="url"]', form).val(KKMurl.get(path+form_id));
	}
});

function display_links() {
	if($('form select[name="orders_device"]').val()=='0') {
		$('tr.display_links').show();
	}
	else {
		$('tr.display_links').hide();
	}
}

$('body').off('change', 'form select[name="orders_device"]');
$('body').on('change', 'form select[name="orders_device"]', function(){
	display_links();
});

$('body').off('change', 'form select[name="cafe_mode"]');
$('body').on('change', 'form select[name="cafe_mode"]', function(){
	if($(this).val()>0) {
		$('tr.cafe_mode').show();
		display_links();
	}
	else {
		$('tr.cafe_mode').hide();
		$('tr.display_links').hide();
	}
});

function egais_orginfo() {
	var href=$('.egais_settings input[name="url_egais"]').val();
	if(href=='') {
		show_window('error', "Не казан путь к УТМ ЕГАИС");
		return;
	}
	show_window('loading', loading_txt);
	$.ajax({
        url: href+'/api/info/list',
        method: 'GET',
        dataType: "html",
        success: function(response) {
        	close_all_window();
        	var isJson=true;
        	var res;
        	try {
    			res=JSON.parse(response);
			} catch(e) {
    			isJson = false;
			}
       		if(isJson) {
       			$('input[name="fsrar_id"]').val(res.ownerId);
       		}
       		else {
       			show_window(null, response);
       		}
    	},
    	error: function(response) {
            $("#loading .popup_content").html(response.statusText);
            $("#loading .close").show();
    	},
    	timeout: 65000
 	});
}

$('body').off('click', '#egais_orginfo_button');
$('body').on('click', '#egais_orginfo_button', function() {
	egais_orginfo();
});

/*if($('#egais_orginfo_button').length>0 && $('.egais_settings input[name="fsrar_id"]').val()!='') {
	egais_orginfo();
}*/

$('body').off('click', '.add_clientsscale');
$('body').on('click', '.add_clientsscale', function() {
	var html=$('#clientsscale_tmp table').html();
	html=html.replace(/@driver_config/g, Math.floor(Date.now() / 1000));
	$(this).closest('table').append(html);
});

$('body').off('click', '.add_epay');
$('body').on('click', '.add_epay', function() {
	var html=$('#epay_tmp table').html();
	html=html.replace(/@driver_config/g, Math.floor(Date.now() / 1000));
	$(this).closest('table').append(html);
});

$('body').off('change', 'select[name="driver[]"]');
$('body').on('change', 'select[name="driver[]"]', function(){
	var href=$(this).attr('href');
	var path=$(this).val();
	var tr=$(this).closest('tr');
	var id=$('input[name="id[]"]', tr).val();
	var print_group_id=$('input[name="driver_config[]"]', tr).val();
	if(path!='') {
		$('.driver_settings', tr).attr('href', href+'?path='+path+'&print_group_id='+print_group_id);
		$('.driver_settings', tr).removeClass('hide');
	}
	else {
		$('.driver_settings', tr).attr('href', '');
		$('.driver_settings', tr).addClass('hide');
	}

	var input=$('input[name="title[]"]', tr);
	if(input.attr('data-changed')==0) {
		input.val($("option:selected", this).attr('title'));
	}
});

$('body').off('change', 'input[name="title[]"]');
$('body').on('change', 'input[name="title[]"]', function(){
	$(this).attr('data-changed', 1);
});

var driver_config_input;
$('body').off('click', '.driver_settings');
$('body').on('click', '.driver_settings', function(){
	var td=$(this).closest('td');
	driver_config_input=$('textarea[name="driver_config[]"]', td);
	show_window('driver_settings_window');
	$('#driver_settings_window .popup_content').load($(this).attr('href')+'&id='+$('input[name="id[]"]', td).val(), function(response, status, xhr) {
		$("#driver_settings_window .close").show();
  		if(status=="error") {
    		$('#driver_settings_window .popup_content').html(xhr.status+" "+xhr.statusText);
  		}
  		else {
  			if(driver_config_input.val()=='' || driver_config_input.val()==undefined) return;
  			$('#driver_settings_window textarea[name="txt"]').html(driver_config_input.val());
  		}
	});
});

// Это было нужно до того как мы начали хранить настройки драйверов в БД
/*$('body').off('click', '#driver_settings_window #settings_epay_driver_save');
$('body').on('click', '#driver_settings_window #settings_epay_driver_save', function(){
	driver_config_input.html($('#driver_settings_window textarea[name="txt"]').val());
	$('#settings_epay_driver_form').attr('action', '/settings/epay_drivers');
	$('#settings_epay_driver_form').submit();
	close_window(this);
});*/

$('body').off('click', '#default_settings');
$('body').on('click', '#default_settings', function(){
	$('#driver_settings_window textarea[name="txt"]').html($('#driver_settings_window textarea[name="default"]').val())
});

$('body').off('click', '.servicebutton');
$('body').on('click', '.servicebutton', function(){
	$('form[name="settings_driver_form"]').attr('action', $(this).attr('href'));
	var success=true;
	$('form[name="settings_driver_form"] *[required="true"]').each(function(){
		if($(this).val()=='') {
			success=false;
		}
	});
	if(success) $('form[name="settings_driver_form"]').submit();
	else show_window('error', '<p class="false">Заполните все обязательные поля</p>');
});

$('body').off('change', 'form[name="settings_epays_form"] .selected_epay');
$('body').on('change', 'form[name="settings_epays_form"] .selected_epay', function() {
	$('form[name="settings_epays_form"] input[name="selected[]"]').val(0);
	var check=$(this).prop('checked');
	if(check) {
		$('form[name="settings_epays_form"] .selected_epay').prop('checked', false);
		$('input[name="selected[]"]', $(this).closest('td')).val(1);
		$(this).prop('checked', true);
	}
});

function kiosk_type_change(select) {
	if($("option:selected", select).attr('data-searchset')==1) {
		$('.kiosk_type_search').show();
	}
	else {
		$('.kiosk_type_search').hide();
	}
}

$('body').off('change', 'form select[name="kiosk_type"]');
$('body').on('change', 'form select[name="kiosk_type"]', function(){
	kiosk_type_change(this);
});

if($('form select[name="kiosk_type"]').length>0) {
	kiosk_type_change($('form select[name="kiosk_type"]'));
}

$('body').off('change, keyup', 'form[name="form_db_config"] input[name="domen"]');
$('body').on('change, keyup', 'form[name="form_db_config"] input[name="domen"]', function(){
	$(this).val($(this).val().toLowerCase());
});

function control_api_settings() {
	$('.api_settings').hide();
	var url=$('input[name="domen"]').val();
	var pass=$('input[name="pass"]').val();
	if(!url || !pass) {
		return;
	}
	$.ajax({
        url: '/api/getstores?url='+url+'&token='+pass,
        method: 'GET',
        dataType: "html",
        success: function(response) {
        	var res=JSON.parse(response);
        	$('.settings_api_error').html('');
			if(res.success===true) {
				$('.api_settings').show();
				$('select[name="store_id"]').html(res.options);
				/*$('select[name="store_id"]').remove();
				$.each(res.stores, function( index, value ) {
					//console.log('id='+value.id);
					$('select[name="store_id"]')
				});*/
				return;
			}
			$('.settings_api_error').html(res.error);
    	},
    	timeout: 65000
 	});
}

if($('.api_settings').length>0) {
	control_api_settings();
}

$('body').off('change, keyup', '.apiset');
$('body').on('change, keyup', '.apiset', function(){
	control_api_settings();
});

$('#use_login_pass').click(function(){
	$('form[name="form_settings_start"]').show();
});

if($('.settings_form input[name="gs1"]').length>0 || $('.settings_form input[name="gs1_symbols"]').length>0) {
	var keypress=0;
	var input_clear=1;
	var clear_timeout;
	var first_key='';
	var last_key='';
	var all_key='';

	function start_symbols_control() {
		$('.settings_form input[name="gs1_symbols"]').val('');
		$('.check_scanner .true').hide();
		$('.check_scanner .false').hide();
	}

	function end_symbols_control() {
		if(first_key==65) {
			$('.check_fnc1 .false').hide();
			$('.check_fnc1 .true').show();
		}
		else {
			$('.check_fnc1 .false').show();
			$('.check_fnc1 .true').hide();
		}
		if(last_key==13 || last_key==8 || last_key==46) {
			$('.check_enter .false').hide();
			$('.check_enter .true').show();
		}
		else {
			$('.check_enter .false').show();
			$('.check_enter .true').hide();
		}
		all_key=all_key.toLowerCase();
		if(all_key!='agorta' && all_key!='фпщкеф') {
			if($('.settings_form input[name="gs1_symbols"]').val()=='') {
				$('.settings_form input[name="gs1_symbols"]').val('<GS>');
			}
		}
		$('.check_gs .false').hide();
		$('.check_gs .true').show();

		keypress=0;
		input_clear=1;
		first_key='';
		last_key='';
		all_key='';
	}

	function gs1_symbols_control(e) {
		e.preventDefault();
		if(e.which==13 || e.which==8 || e.which==46) {
			clearTimeout(clear_timeout);
			last_key=e.which;
			end_symbols_control();
			return;
		}
		if(input_clear==1) {
			start_symbols_control();
		}
		input_clear=0;
		clearTimeout(clear_timeout);
		clear_timeout=setTimeout(end_symbols_control, 1000);
		var val=$('.settings_form input[name="gs1_symbols"]').val()+e.key;
		val=val.replace(/agorta/gi, '');
		val=val.replace(/фпщкеф/gi, '');
		$('.settings_form input[name="gs1_symbols"]').val(val);
	}

	$('.settings_form input[name="gs1_symbols"]').keyup(function(e){
		if(first_key=='' && e.which!=13 && e.which!=8 && e.which!=46) {
			first_key=e.which;
		}
		last_key=e.which;
		keypress=0;
		all_key+=e.key;
	});
	$('.settings_form input[name="gs1_symbols"]').keypress(function(e){
		gs1_symbols_control(e);
		keypress=1;
	});

	$(document).off('keydown', 'body');
	$(document).on('keydown', 'body', function(e){
		if($('.settings_form input[name="gs1_symbols"]').length>0 && !$('.settings_form input[name="gs1_symbols"]').is(':focus')) {
			$('.settings_form input[name="gs1_symbols"]').val('');
			$('.settings_form input[name="gs1_symbols"]').focus();
		}
	});
}

$('select[name="product_menu"]').change(function(){
	$('.product_menu').hide();
	$('.product_menu_'+$(this).val()).show();
});

if($('form[name="settings_pricechecker_form"]').length>0) {
	const U = new SpeechSynthesisUtterance();
	var voices = speechSynthesis.getVoices();
	var defaultVoiceIndex;

	function add_voices(){
		voices = speechSynthesis.getVoices();
		voices.forEach(function(voice, index) {
			var html='<option value="'+voice.name+'" '+(voice.name==pricechecker_voice?'selected="selected"':'')+'>'+voice.name+'</option>';
			$('form[name="settings_pricechecker_form"] select[name="pricechecker_voice"]').append(html);
		});

	}

	setTimeout(add_voices, 100);

	$('#pricechecker_speek_test').click(function(){
		if(voices.length==0) return;
  		U.text='Агорта - лучшая программа. Агорта лучше всех. Славься, славься отдел разработки Агорты!';
		// Получаем выбранный голос
		var selected_voice=voices.findIndex(
    		(voice)=>voice.name===$('form[name="settings_pricechecker_form"] select[name="pricechecker_voice"]').val()
  		);
		const voice=voices[selected_voice];
		// Передаем голос и другие настройки экземпляру
		U.voice=voice;
		// язык
		U.lang=voice.lang;
		// громкость
		U.volume=$('form[name="settings_pricechecker_form"] input[name="pricechecker_volume"]').val()/100;
		// скорость
		U.rate=$('form[name="settings_pricechecker_form"] input[name="pricechecker_rate"]').val()/100;
		// высота голоса
		U.pitch=$('form[name="settings_pricechecker_form"] input[name="pricechecker_pitch"]').val()/100;
		// Запускаем озвучивание!
		speechSynthesis.speak(U);
	});
}

$('body').off('change', 'form[name="settings_kkm_registration_form"] select[name="ffd"]');
$('body').on('change', 'form[name="settings_kkm_registration_form"] select[name="ffd"]', function(){
	$('.why').hide();
	var ffd0=$(this).attr('data-ffd');
	var ffd=$(this).val();
	var ffd_class='.why_'+ffd.replace('.', '_');
	$(ffd_class).show();
	if(ffd0!='' && ffd0!=ffd) {
		$('input[data-because="ffd"]').closest('tr').show();
		$('input[data-because="ffd"]').attr('disabled', false);
		$('input[data-because="ffd"]').prop('checked', true);
		$('input[data-because="ffd"]').change(function(){
			$('input[data-because="ffd"]').prop('checked', true);
		});
	}
	else {
		$('input[data-because="ffd"]').closest('tr').hide();
		$('input[data-because="ffd"]').prop('checked', false);
		$('input[data-because="ffd"]').attr('disabled', true);
		$('input[data-because="ffd"]').change(function(){
			$('input[data-because="ffd"]').prop('checked', false);
		});
	}
});

if($('form[name="settings_kkm_registration_form"] select[name="ffd"]').length>0) {
	$('form[name="settings_kkm_registration_form"] select[name="ffd"]').trigger('change');
}

$('body').off('click', '#add_new_printer');
$('body').on('click', '#add_new_printer', function(){
	$('.printer_settings_show').show();
	var id=0;
	$('input[name="print_group_id"]').each(function(){
		if($(this).val()>id) id=$(this).val();
	});
	id=id*1+1;
	if($('form[name="settings_kitchen_form"]').length>0) {
		$('form[name="settings_kitchen_form"]').hide();
		var html='<form name="settings_kitchen_form" action="/settings/kitchen_printer" method="POST" id="printer_form_new_'+id+'">'+$('.first_printer').html()+'</form>';
	}

	if($('form[name="settings_bar_form"]').length>0) {
		$('form[name="settings_bar_form"]').hide();
		var html='<form name="settings_bar_form" action="/settings/bar_printer" method="POST" id="printer_form_new_'+id+'">'+$('.first_printer').html()+'</form>';
	}
	$('.settings_form').append(html);
	$('#printer_form_new_'+id).trigger('reset');
	$('#printer_form_new_'+id).show();
	$(this).closest('div').append('<button type="button" class="printer_settings_show" data-id="new_'+id+'">Принтер '+id+'</button>');
	$('#printer_form_new_'+id+' select[name="active"]').val(1);
	$('#printer_form_new_'+id+' select[name="active"]').trigger('change');
	$('#printer_form_new_'+id+' input[name="print_group_id"]').val(id);
	$('#printer_form_new_'+id+' .printer_title').html(id);
	$('#printer_form_new_'+id+' select[name="print_group_driver"]').val('');
	$('#printer_form_new_'+id+' .print_group_driver_settings').addClass('hide');
	$('#printer_form_new_'+id+' .print_group_driver_settings').attr('href', '');
	$('#printer_form_new_'+id+' input[name="url"]').val('http://127.0.0.1:8888/req');
});

$('body').off('click', '.printer_settings_show');
$('body').on('click', '.printer_settings_show', function(){
	var id=$(this).attr('data-id');
	$('form[name="settings_kitchen_form"]').hide();
	$('form[name="settings_bar_form"]').hide();
	$('#printer_form_'+id).show();
});

$('body').off('click', '.checktoken');
$('body').on('click', '.checktoken', function() {
	var href='/settings/checktoken?token='+$('input[name="token_chz"]').val();
	load_window(href);
});

$('body').off('change', 'select[name="chz_offline"]');
$('body').on('change', 'select[name="chz_offline"]', function () {
	if($(this).val()==1) {
		$('.chz_offline_url').show();
	}
	else {
		$('.chz_offline_url').hide();
	}
});

$('body').off('click', '#chz_offline_check');
$('body').on('click', '#chz_offline_check', function() {
	var token=$('input[name="token_chz"]').val();
	var href=$('input[name="chz_offline_url"]').val();
	var login=$('input[name="chz_offline_login"]').val();
	var pass=$('input[name="chz_offline_pass"]').val();
	var error='';
	if(token=='') {
		error='Укажите токен в Честном Знаке';
	}
	if(href=='') {
		error='Укажите путь для оффлайн проверки';
	}
	if(login=='') {
		error='Укажите логин для оффлайн проверки';
	}
	if(pass=='') {
		error='Укажите пароль для оффлайн проверки';
	}

	if(error!='') {
		show_window('error', '<p class="false">'+error+'</p>');
		return;
	}
	show_window('loading', loading_txt);
	$.ajax({
        url: '/chz/lmstatus',
        method: 'POST',
        data: {'chz_offline_url': href, 'chz_offline_login': login, 'chz_offline_pass': pass, 'service': 1},
        success: function(res) {
        	close_window('#loading');
        	try {
    			response=JSON.parse(res);
    			if(response.success===false) {
    				show_window('error', '<p class="false">'+response.txt+'</p>');	
    			}
    			else {
		        	var txt='<p>Статус ЛМ ЧЗ: '+response.status_txt+'</p>';
		        	if(response.status=='not_configured' && response.status!='initialization') {
		        		txt+='<p align="center"><input type="button" id="chz_offline_init" value="Инициализация"></p>';
		        	}
		        	show_window('result', txt);
		        }
			} catch(e) {
    			show_window('error', '<p class="false">'+res+'</p>');
			}
    	},
    	error: function(response) {
    		close_window('#loading');
    		show_window('error', '<p class="false">'+response.statusText+'</p>');
    	},
    	timeout: 6000
 	});
});

$('body').off('click', '#chz_offline_init');
$('body').on('click', '#chz_offline_init', function() {
	close_window('#result');
	var token=$('input[name="token_chz"]').val();
	var href=$('input[name="chz_offline_url"]').val();
	var login=$('input[name="chz_offline_login"]').val();
	var pass=$('input[name="chz_offline_pass"]').val();
	var error='';
	if(token=='') {
		error='Укажите токен в Честном Знаке';
	}
	if(href=='') {
		error='Укажите путь для оффлайн проверки';
	}
	if(login=='') {
		error='Укажите логин для оффлайн проверки';
	}
	if(pass=='') {
		error='Укажите пароль для оффлайн проверки';
	}

	if(error!='') {
		show_window('error', '<p class="false">'+error+'</p>');
		return;
	}
	show_window('loading', loading_txt);
	$.ajax({
        url: '/chz/lminit',
        method: 'POST',
        data: {'chz_offline_url': href, 'chz_offline_login': login, 'chz_offline_pass': pass, 'token_chz': token},
        success: function(res) {
        	close_window('#loading');
        	try {
    			response=JSON.parse(res);
	        	if(response.success) {
	        		show_window('result', 'Запрос отправлен');
	        	}
	        	else {
	    			show_window('error', '<p class="false">'+response.txt+'</p>');
	        	}
	        } catch(e) {
    			show_window('error', '<p class="false">'+res+'</p>');
			}
    	},
    	error: function(response) {
    		if(response.statusText=='OK') {
    			close_window('#loading');
        		show_window('result', 'Запрос отправлен');
        		return;
    		}
    		close_window('#loading');
    		show_window('error', '<p class="false">'+response.statusText+'</p>');
    	},
    	timeout: 6000
 	});
});

$('body').off('change', 'select[name="chz_alarm"]');
$('body').on('change', 'select[name="chz_alarm"]', function () {
	if($(this).val()>=1) $('.chz_alarm').show();
	else $('.chz_alarm').hide();
});

$('body').off('click', '.deleteepay_tr');
$('body').on('click', '.deleteepay_tr', function () {
	$(this).closest('tr').remove();
});

$('body').off('click', '.deleteclientsscale_tr');
$('body').on('click', '.deleteclientsscale_tr', function () {
	$(this).closest('tr').remove();
});

function drivers_get_options(form) {
	$('input', form).blur();
	var submit_button=$('input[type="submit"]', form);
	submit_button.attr('disabled', 'disabled');
	var formData = $(form).serialize();
	var method=$('input[name="options_method"]', form).val();
	$('.'+method+'_error', form).html('Загрузка...');
	var select=$('select[data-getoptions="'+method+'"]');
	select.html('');
	$.ajax({
        url: '/settings/driversgetoptions',
        type: 'POST',
        dataType: "html",
        data: formData,
        success: function(response) {
        	submit_button.removeAttr('disabled');
        	try {
    			var res=JSON.parse(response);
    			if(res.success) {
    				$('.'+method+'_error', form).html('');
    				var options='';
    				$.each(res.options, function(n, val){
    					var selected='';
    					if(val[1]==select.data('value')) {
    						selected=' selected="selected" ';
    					}
    					options+='<option value="'+val[1]+'" '+selected+'>'+val[0]+'</option>';
    				});
    				select.html(options);
    			}
    			else {
    				$('.'+method+'_error', form).html(res.txt);
    			}
			} catch(e) {
    			$('.'+method+'_error', form).html(response);
			}
        	$("#loading").remove();
    	},
    	error: function(response) {
    		false_alarm();
    		submit_button.removeAttr('disabled');
    		$('.'+method+'_error', form).html(response);
    	},
    	timeout: 305000
 	});
}

$('body').off('click', '.drivers_get_options');
$('body').on('click', '.drivers_get_options', function() {
	drivers_get_options_click(this);
});

function drivers_get_options_click(elem) {
	var form=$(elem).closest('form').get(0);
	$('input[name="options_method"]', form).val($(elem).data('value'));
	drivers_get_options(form);
}