<?php
namespace Controllers;
// Контроллер Настроек
class Settings extends Controller {

	public function __construct() {
		parent::__construct();
		if($this->db) {
			$this->model=new \Models\Settings($this->f3, $this->db);
		}
		else {
			$this->model=new \Models\Settings($this->f3);
		}
	}

	function start() {
		$this->f3->set('page_data', $this->model->page_data('start'));
	}

	function post_start(){
		$post=$this->f3->get('POST');
		$api=new \Models\Api($this->f3, $post['domen'], null, null, null);
		$res=$api->gen_api_key($post);
		if($res['success']!==true) {
			if($res['txt']) {
				$error=$this->messages->message($res['txt'][0])['txt'];
				$this->f3->set('error', $error);
			}
			else {
				$error=$this->messages->message($res['error'][0])['txt'];
				$this->f3->set('error', $error);
			}
			$this->f3->set('page_data', $this->model->page_data('start'));
		}
		else {
			$this->f3->reroute('/settings/api?domen='.$post['domen'].'&key='.$res['key']);
		}
	}

	function scaner(){
		$this->f3->set('page_data', $this->model->page_data('scaner'));
	}

	function post_scaner(){
		$post=$this->f3->get('POST');
		$res=$this->model->save_base($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки для подключения к API
	function api() {
		$this->f3->set('page_data', $this->model->page_data('api'));
	}

	// Сохраняем настройки для подключения к API
	function post_api() {
		$post=$this->f3->get('POST');
		$post['old_rm_id']=$this->api_data['rm_id'];
		$res=$this->model->post_api($post); // пытаемся сохранить настройки
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройка для автономного режима
	function autonomous() {
		$this->f3->set('api_data', $this->api_data);
		if($this->db) {
			$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
			$kkm_data=$fr->get_fr();
			$this->f3->set('kkm_data', $kkm_data);
		}
		$this->f3->set('page_data', $this->model->page_data('autonomous'));
	}

	// Сохранение настроек для автономного режима
	function post_autonomous() {
		$data=$this->f3->get('POST');
		if($this->api_data) {
			$data['old_rm_id']=$this->api_data['rm_id'];
			$data['store_id']=$this->api_data['store_id'];
			$data['domen']=$this->api_data['domen'];
			$data['pass']=$this->api_data['pass'];
			$data['limit']=$this->api_data['limit'];
		}
		else {
			$data['store_id']=1;
		}
		$this->model->create_config_api($data);

		if(!$this->db) {
			$data['users']=array(
				'usergroups'=>array(
					array(
						'id'=>1,
						'title'=>'',
						'module'=>''
					)
				),
				'users'=>array(
					array(
						'id'=>1,
						'name'=>'Администратор',
						'short_name'=>'Администратор',
						'group_id'=>1,
						'pass'=>'',
						'date_delete'=>0,
						'type'=>3
					)
				)
			);
			$data['paymentmethods']=array(
				array(
					'id'=>1,
					'title'=>'Наличные',
					'cash'=>1
				),
				array(
					'id'=>2,
					'title'=>'Безналичные',
					'cash'=>0
				)
			);
			$api=new \Models\Api($this->f3, '', '', '', '');
			$partners=array();
			if($data['partner_id']>0) {
				$partners[]=$data['partner_id'];
			}
			$license=$api->gen_license($partners);
			if(!$license['success']) {
				echo json_encode($license);
				exit();
			}
			$data['license']=array(
				'license_key'=>$license['key']
			);
			$res=$this->controller->create_database($this->f3->get('db_instance'), $this->f3->get('db_name'), $data); // при необходимости создаем базу
			if($res['success']) {
				$this->f3->reroute('/');
			}
		}
		else {
			$res=$this->model->save_autonomous($data);
		}

		$res['txt']=$this->messages->message($res['txt'])['txt'];
		if($res['success'] && $data['autonomous']==0 && $this->api_data['domen']=='') {
			unset($res['reload_menu']);
			$res['reroute']='/';
		}
		echo json_encode($res);
		exit();
	}

	// Страница синхронизации
	function synchronization() {
		$data=$this->db->exec("SELECT auto_sinch, tickets_update FROM synchronization LIMIT 1");
		$this->f3->set('auto_sinch', $data[0]['auto_sinch']);
		$this->f3->set('tickets_update', $data[0]['tickets_update']);
		$this->f3->set('page_data', $this->model->page_data('synchronization'));
	}

	// Включаем или выключаем автосинхронизацию
	function post_synchronization() {
		$auto_sinch=$this->f3->get('POST.auto_sinch');
		$res=$this->model->post_synchronization($this->db, $auto_sinch);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	// Продолжение печати, выход из аварийного состояни
	function continue_print() {
		$fr=new \Models\Fr($this->db, $this->f3);
		$res=$fr->continue_print();
		$this->f3->set('page_data', $this->messages->message($res['txt']));
	}

	// Обнуление чека
	function reset_ticket() {
		$fr=new \Models\Fr($this->db, $this->f3);
		$res=$fr->reset_ticket();
		$this->f3->set('page_data', $this->messages->message($res['txt']));
	}

	// Настройка фискального регистратора
	function kkm() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
		$data=$fr->get_fr();
		$this->f3->set('data', $data);
		$drivers=$fr->get_drivers();
		$this->f3->set('drivers', $drivers);
		$p=new \Models\Paymentmethods($this->db, $this->f3);
		$pays=$p->select_method();
		$this->f3->set('pays', $pays);
		$this->f3->set('page_data', $this->model->page_data('kkm'));
	}

	// Сохраняем настройки ФР
	function post_kkm() {
		$post=$this->f3->get('POST');
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
		$res=$fr->save_fr($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.kkm_drivers_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки банковского терминала
	function bankterminal() {
		$bt=new \Models\BankTerminal($this->db, $this->f3);
		$data=$bt->sets;
		$this->f3->set('data', $data);
		$drivers=$bt->get_drivers();
		$this->f3->set('drivers', $drivers);
		$this->f3->set('page_data', $this->model->page_data('bankterminal'));
	}

	// Сохраняем настройки ФР
	function post_bankterminal() {
		$post=$this->f3->get('POST');
		$bt=new \Models\BankTerminal($this->db, $this->f3);
		$res=$bt->save_sets($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Сброс всех настроек и удаление базы данных
	function reset() {
		$res=$this->model->reset();
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Ошибки при синхронизации
	function logs() {
		$limit=$this->f3->get('lines_of_page');
		$page=$this->f3->get('GET.page');
		if(!$page)$page=1;
		$logs=$this->logs->logs_list(($page-1)*$limit, $limit);
		$this->f3->set('logs', $logs['logs']);
		$this->f3->set('pagination', $this->pagination($logs['count'], $page));
		$this->f3->set('page_data', $this->model->page_data('logs'));
	}

	function post_logs() {
		$id=$this->f3->get('POST.id');
		$res=$this->logs->read($id);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	function read_all_logs() {
		$res=$this->logs->read_all();
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройка дисплея покупателя
	function customer_display() {
		$data=$this->cd->get_cd();
		$drivers=$this->cd->get_drivers();
		$this->f3->set('drivers', $drivers);
		$this->f3->set('data', $data);
		$this->f3->set('page_data', $this->model->page_data('cd'));
	}

	// Сохраняем настройки дисплея покупателя
	function post_customer_display() {
		$post=$this->f3->get('POST');
		if(!$this->cd) {
			$this->cd=new \Models\Cd($this->db, $this->f3);
		}
		$this->model->save_base(array('cd_logo_x'=>$post['cd_logo_x'], 'cd_logo_y'=>$post['cd_logo_y'], 'cd_time_advs_src'=>$post['cd_time_advs_src']));
		$res=$this->cd->save_cd($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Страница сервисных команд
	function service() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
		$fr_settings=$fr->get_fr();
		$this->f3->set('fr_settings', $fr_settings);
		$epay=new \Models\Epays($this->db, $this->f3);
		$epays=$epay->select_epays(array('active=1'));
		$this->f3->set('epays', $epays);
		$this->f3->set('page_data', $this->model->page_data('service'));
	}

	// Произвольная команда
	function post_service() {
		$strs=$this->f3->get('POST.commands');
		$fr=new \Models\Fr($this->db, $this->f3);
		$fr_sets=$fr->get_fr();
		if($fr_sets['active']) {
			$strs=$fr->replace_strs($strs);
			$fr->fr->send_ajax($strs, null, true);
			exit();
		}
		$res=array(
			'success'=>false,
			'txt'=>$this->messages->message('kkm_is_not_activity')['txt']
		);
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Запрос полного статуса ККМ
	function status_kkm() {
		$fr=new \Models\Fr($this->db, $this->f3);
		$fr_sets=$fr->get_fr();
		if($fr_sets['active']) {
			$fr->status_kkm();
			exit();
		}
		$res=array(
			'success'=>false,
			'txt'=>$this->messages->message('kkm_is_not_activity')['txt']
		);
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Сверка итогов
	function epay_close() {
		$this->changes=new \Models\Changes($this->db, $this->f3);
		$change=$this->changes->get_change(false, false); // Не открывать смену
		$epay=new \Models\Epays($this->db, $this->f3);
		$epays=$epay->select_epays(array('active=1'));
		$success=true;
		$txt='';

		if($epays) {
			$fr=new \Models\Fr($this->db, $this->f3);
			$slip='';
			foreach($epays as $e) {
				$epay=new \Models\Epays($this->db, $this->f3, $e['id']);
				$res=$epay->z($change);
				if($res['success']){
					$slip.=$res['slip'].'#kkm_br#';
				}
				else {
					$success=false;
					$txt.=$res['txt']."\n";
				}
			}
			$slip=str_replace("\n", '', $slip);
			$slip=str_replace("\r", '', $slip);
			$slip='p;'.preg_replace('/\<br(\s*)?\/?\>/i', "#kkm_br#", $slip).";\n";
			$fr->send_ajax($slip);
		}

		if($success) {
			$txt=$this->messages->message('success')['txt'];
		}
		$res=array(
			'success'=>$success,
			'txt'=>$txt
		);
		echo json_encode($res);
		exit();
	}

	// Страница основных настроек программы
	function base() {
		$this->f3->set('timezones', $this->model->get_timezones());
		$this->f3->set('page_data', $this->model->page_data('base'));
	}

	// Сохраняем основные настройки программы
	function post_base() {
		$post=$this->f3->get('POST');
		if(!isset($post['auto_fullscreen']))$post['auto_fullscreen']=0;
		if(!isset($post['virtual_keyboard']))$post['virtual_keyboard']=0;
		if(!isset($post['view_all_receipts']))$post['view_all_receipts']=0;
		if(!isset($post['modifiers_window']))$post['modifiers_window']=0;
		if(!isset($post['dark_theme']))$post['dark_theme']=0;
		if(!isset($post['round_kop']))$post['round_kop']=0;
		if(!isset($post['auto_issued']))$post['auto_issued']=0;
		if(!isset($post['auto_sales_receipts']))$post['auto_sales_receipts']=0;
		if(!isset($post['animation']))$post['animation']=0;
		if(!isset($post['ticket_description']))$post['ticket_description']=0;
		if(!isset($post['timeout_popup']))$post['timeout_popup']=0;
		if(!isset($post['ticket_print_default']))$post['ticket_print_default']=0;
		if(!isset($post['show_product_img']))$post['show_product_img']=0;
		if(!isset($post['control_stock']))$post['control_stock']=0;
		if(!isset($post['line_merge']))$post['line_merge']=0;
		if(!isset($post['show_product_code']))$post['show_product_code']=0;
		if(!isset($post['show_product_compound']))$post['show_product_compound']=0;
		$res=$this->model->save_base($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройка киоска
	function kiosk() {
		$this->f3->set('kiosk_types', $this->model->get_kiosk_types());
		$this->f3->set('themes', $this->model->get_themes());
		$this->f3->set('page_data', $this->model->page_data('kiosk'));
	}

	// Сохраняем настройка киоска
	function post_kiosk() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_kiosk($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Страница настроек работы с маркировкой
	function marking() {
		$this->f3->set('marktype', $this->sets['marktype']);
		$p=new \Models\Piot($this->db, $this->f3);
		$this->f3->set('piot_drivers', $p->get_drivers());
		$this->f3->set('page_data', $this->model->page_data('marking'));
	}

	// Сохраняем основные настройки программы
	function post_marking() {
		$post=$this->f3->get('POST');
		if(!isset($post['check_mark']))$post['check_mark']=0;
		if(!isset($post['auto_replacekey']))$post['auto_replacekey']=0;

		$now=time();
		foreach($this->sets['marktype'] as $n=>$data) {
			if(!isset($post['required_check_'.$n]))$post['required_check_'.$n]=0;
			if(strtotime($data['required_check'])<$now) {
				$post['required_check_'.$n]=1;
			}
		}

		$res=$this->model->save_base($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Управление залами
	function rooms() {
		$id=$this->f3->get('GET.id');
		$r=new \Models\Rooms($this->db, $this->f3);
		$rooms=$r->select_rooms();
		$room=$rooms[0];
		$tables=array();
		if($id) {
			// Находим выбранный зал
			foreach ($rooms as $r) {
				if($r['id']==$id) {
					$room=$r;
					break;
				}
			}
		}
		if(!empty($room)) {
			// Если зал выбран, то находим столы
			$t=new \Models\Tables($this->db, $this->f3);
			$tables=$t->tables_from_room($room['id']);
		}
		$this->f3->set('room', $room);
		$this->f3->set('tables', $tables);
		$this->f3->set('rooms', $rooms);
		$this->f3->set('page_data', $this->model->page_data('rooms'));
	}

	// Настройка драйвера через визуальную форму
	function driver_form() {
		$path=$this->f3->get('GET.path');
		$device=$this->f3->get('GET.device');
		if(!$device)$device='kkm';
		$this->f3->set('device', $device);
		$print_group_id=$this->f3->get('GET.print_group_id');
		if(!$print_group_id)$print_group_id=0;

		$config=$this->model->get_driver_config($path, $device, $print_group_id, $this->f3->get('GET.default'));
		$this->f3->set('config', $config);
		$this->f3->set('page_data', $this->model->page_data('driver_form'));
	}

	// Сохраняем настройки драйвера из визуальной формы
	function post_driversform() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_driver_form($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.kkm_drivers_init');
			$this->f3->clear('COOKIE.pre_drivers_init');
			$this->f3->clear('COOKIE.kitchen_drivers_init');
			$this->f3->clear('COOKIE.bar_drivers_init');
			$this->f3->clear('COOKIE.drivers_cd_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройка драйвера
	function drivers() {
		$path=$this->f3->get('GET.path');

		if(file_exists($path.'/driver.config')) {
			return $this->driver_form();
		}

		$file=$path.'/server.config';
		
		$device=$this->f3->get('GET.device');
		if(!$device)$device='';
		$this->f3->set('device', $device);

		$print_group_id=$this->f3->get('GET.print_group_id');
		if(!$print_group_id)$print_group_id='';
		$this->f3->set('print_group_id', $print_group_id);
		if($this->f3->get('GET.default')) {
			$file=$path.'/server.config.default';
		}
		elseif($device!='') {
			if($print_group_id!='' && file_exists($path.'/'.$device.'_'.$print_group_id.'_server.config')) {
				$file=$path.'/'.$device.'_'.$print_group_id.'_server.config';
			}
			elseif(file_exists($path.'/'.$device.'_server.config')) {
				$file=$path.'/'.$device.'_server.config';
			}
			elseif(file_exists($path.'/server.config.default')) {
				$file=$path.'/server.config.default';
			}
		}

		if(file_exists($file)) {
			$txt=file_get_contents($file);
			$config=parse_ini_file($file);
			$this->f3->set('config', $config);
			$this->f3->set('txt', $txt);
			$this->f3->set('page_data', $this->model->page_data('drivers'));
		}
		else {
			$this->f3->set('page_data', $this->messages->message('not_found'));
		}
	}

	// Сохраняем настройки драйвера
	function post_drivers() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_driver($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.kkm_drivers_init');
			$this->f3->clear('COOKIE.pre_drivers_init');
			$this->f3->clear('COOKIE.kitchen_drivers_init');
			$this->f3->clear('COOKIE.bar_drivers_init');
			$this->f3->clear('COOKIE.drivers_cd_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Запуск драйвера
	function start_driver() {
		$driver=$this->f3->get('GET.path');
		$device=$this->f3->get('GET.device');
		$res=$this->model->start_driver($driver, $device);
		$this->f3->set('page_data', $this->messages->message($res['txt']));
	}

	function post_driversgetoptions() {
		$post=$this->f3->get('POST');
		$res=$this->model->driversgetoptions($post);
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Окно изменения времени выгрузки чеков
	function update_ticket_time() {
		$data=$this->db->exec("SELECT tickets_update FROM synchronization LIMIT 1");
		$this->f3->set('tickets_update', $data[0]['tickets_update']);
		$this->f3->set('page_data', $this->model->page_data('update_ticket_time'));
	}

	// Сохранение изменения времени выгрузки чеков
	function post_update_ticket_time() {
		$data=$this->f3->get('POST.date_time');
		$res=$this->model->save_ticket_time($this->db, $data);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки весов
	function scales() {
		$scales=new \Models\Scales($this->db, $this->f3);
		$data=$scales->sets;
		$drivers=$scales->get_drivers();
		$this->f3->set('drivers', $drivers);
		$this->f3->set('data', $data);
		$this->f3->set('page_data', $this->model->page_data('scales'));
	}

	// Сохраняем настройки весов
	function post_scales() {
		$scales=new \Models\Scales($this->db, $this->f3);
		$post=$this->f3->get('POST');
		$res=$scales->save_scales($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки принтера для кухни
	function kitchen_printer() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kitchen', false);
		$data=$fr->get_printers(array('printer=?', 'kitchen'));
		$this->f3->set('printers', $data);
		$drivers=$fr->get_drivers();
		$this->f3->set('drivers', $drivers);
		$p=new \Models\Paymentmethods($this->db, $this->f3);
		$pays=$p->select_method();
		$this->f3->set('pays', $pays);
		$this->f3->set('page_data', $this->model->page_data('kitchen_printer'));
	}

	// Сохранение настроек принтера для кухни
	function post_kitchen_printer() {
		$post=$this->f3->get('POST');
		$post['driver']=$post['print_group_driver'];
		if(!isset($post['line_by_line']))$post['line_by_line']=0;
		if(!isset($post['one_line']))$post['one_line']=0;
		$fr=new \Models\Fr($this->db, $this->f3, 'kitchen', false, $post['print_group_id']);
		$res=$fr->save_fr($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.kitchen_drivers_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки принтера пречеков
	function pre_printer() {
		$fr=new \Models\Fr($this->db, $this->f3, 'pre', false);
		$data=$fr->get_fr();
		$this->f3->set('data', $data);
		$drivers=$fr->get_drivers();
		$this->f3->set('drivers', $drivers);
		$p=new \Models\Paymentmethods($this->db, $this->f3);
		$pays=$p->select_method();
		$this->f3->set('pays', $pays);
		$this->f3->set('page_data', $this->model->page_data('pre_printer'));
	}

	// Сохранение настроек принтера пречеков
	function post_pre_printer() {
		$post=$this->f3->get('POST');
		$fr=new \Models\Fr($this->db, $this->f3, 'pre', false);
		$res=$fr->save_fr($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.pre_drivers_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки принтера для бара
	function bar_printer() {
		$fr=new \Models\Fr($this->db, $this->f3, 'bar', false);
		$data=$fr->get_printers(array('printer=?', 'bar'));
		$this->f3->set('printers', $data);
		$drivers=$fr->get_drivers();
		$this->f3->set('drivers', $drivers);
		$p=new \Models\Paymentmethods($this->db, $this->f3);
		$pays=$p->select_method();
		$this->f3->set('pays', $pays);
		$this->f3->set('page_data', $this->model->page_data('bar_printer'));
	}

	// Сохранение настроек принтера для бара
	function post_bar_printer() {
		$post=$this->f3->get('POST');
		$post['driver']=$post['print_group_driver'];
		if(!isset($post['line_by_line']))$post['line_by_line']=0;
		if(!isset($post['one_line']))$post['one_line']=0;
		$fr=new \Models\Fr($this->db, $this->f3, 'bar', false, $post['print_group_id']);
		$res=$fr->save_fr($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.bar_drivers_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки принтера для этикеток
	function pricetags_printer() {
		$fr=new \Models\Fr($this->db, $this->f3, 'pricetags', false);
		$data=$fr->get_fr();
		$this->f3->set('data', $data);
		$drivers=$fr->get_drivers();
		$this->f3->set('drivers', $drivers);
		$p=new \Models\Paymentmethods($this->db, $this->f3);
		$pays=$p->select_method();
		$this->f3->set('pays', $pays);
		$this->f3->set('page_data', $this->model->page_data('pricetags_printer'));
	}

	// Сохранение настроек принтера для прайсчекера
	function post_pricetags_printer() {
		$post=$this->f3->get('POST');
		$fr=new \Models\Fr($this->db, $this->f3, 'pricetags', false);
		$res=$fr->save_fr($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		if($res['success']) {
			$this->f3->clear('COOKIE.pricetags_drivers_init');
		}
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Вызов меню кассира для банковского терминала
	function post_cashermenu() {
		$config=$this->f3->get('POST');
		//$config=parse_ini_string($post['txt']);
		$epay=new \Models\Epays($this->db, $this->f3);
		$epay->startwithconfig($config['path'], $config['params']);
		$res=$epay->cashermenu();
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Вызов меню админа для банковского терминала
	function post_adminmenu() {
		$config=$this->f3->get('POST');
		//$config=parse_ini_string($post['txt']);
		$epay=new \Models\Epays($this->db, $this->f3);
		$epay->startwithconfig($config['path'], $config['params']);
		$res=$epay->adminmenu();
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Проверка связи
	function post_testconnection() {
		$config=$this->f3->get('POST');
		//$config=parse_ini_string($post['txt']);
		$epay=new \Models\Epays($this->db, $this->f3);
		$epay->startwithconfig($config['path'], $config['params']);
		$res=$epay->testconnection();
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Страница настройки оборудования
	function devices() {
		$this->f3->set('page_data', $this->model->page_data('devices'));
	}

	// Страница настройки весов самообслуживания
	function clientsscales() {
		$clientsscales=new \Models\Clientsscales($this->db, $this->f3, $this->api_data);
		$scales=$clientsscales->select_scales();
		$this->f3->set('scales', $scales);
		$drivers=$clientsscales->get_drivers();
		$this->f3->set('drivers', $drivers);
		$this->f3->set('page_data', $this->model->page_data('clientsscales'));
	}

	// Сохранение настройки весов самообслуживания
	function post_clientsscales() {
		$post=$this->f3->get('POST');
		$ip=array(
			'ip_clientsscales_range_start'=>$post['ip_clientsscales_range_start'],
			'ip_clientsscales_range_end'=>$post['ip_clientsscales_range_end']
		);
		$res=$this->model->save_base($ip);
		if($res['success']===true) {
			$clientsscales=new \Models\Clientsscales($this->db, $this->f3, $this->api_data);
			$res=$clientsscales->save_scales($post);
		}
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Удаление весов самообслуживания
	function deleteclientsscales() {
		$get=$this->f3->get('GET');
		$clientsscales=new \Models\Clientsscales($this->db, $this->f3, $this->api_data);
		$res=$clientsscales->delete_scale($get['id']);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки драйвера весов самообслуживания
	function clientsscales_drivers() {
		$get=$this->f3->get('GET');
		if(!$get['print_group_id']) {
			$get['print_group_id']=time();
			$this->f3->set('GET.print_group_id', $get['print_group_id']);
		}
		$this->f3->set('device', 'clientsscales');
		$config=$this->model->get_driver_config($get['path'], 'clientsscales', $get['print_group_id'], $get['default']);
		if($config) {
			$this->f3->set('config', $config);
			$this->f3->set('page_data', $this->model->page_data('driver_form'));
		}
		else {
			$this->f3->set('page_data', $this->messages->message('not_found'));
		}
	}

	// Страница настройки электронных методов оплаты
	function epays() {
		$epays=new \Models\Epays($this->db, $this->f3);
		$methods=$epays->select_epays();
		$this->f3->set('methods', $methods);
		$drivers=$epays->get_drivers();
		$this->f3->set('drivers', $drivers);
		$this->f3->set('page_data', $this->model->page_data('epays'));
	}

	// Сохранение электронных методов оплаты
	function post_epays() {
		$epays=new \Models\Epays($this->db, $this->f3);
		$post=$this->f3->get('POST');
		$res=$epays->save_epays($post);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Настройки по-умолчанию драйвера метода электронной оплаты
	function epay_drivers() {
		$get=$this->f3->get('GET');
		if(!$get['print_group_id']) {
			$get['print_group_id']=time();
			$this->f3->set('GET.print_group_id', $get['print_group_id']);
		}
		$this->f3->set('device', 'epay');
		/*if(file_exists($path.'/server.config.default')) {
			$default=file_get_contents($path.'/server.config.default');
		}
		else {
			$default=file_get_contents($path.'/server.config');
		}*/
		$config=$this->model->get_driver_config($get['path'], 'epay', $get['print_group_id'], $get['default']);
		if($config) {
			$epays=new \Models\Epays($this->db, $this->f3);
			$epays->startwithconfig($get['path'], $config['config']);
			if(method_exists($epays->epay, 'testconnection')) {
				$this->f3->set('testconnection', true);
			}
			if(method_exists($epays->epay, 'cashermenu')) {
				$this->f3->set('cashermenu', true);
			}
			if(method_exists($epays->epay, 'adminmenu')) {
				$this->f3->set('adminmenu', true);
			}
			$this->f3->set('config', $config);
			$this->f3->set('page_data', $this->model->page_data('driver_form'));
		}
		else {
			$this->f3->set('page_data', $this->messages->message('not_found'));
		}
	}

	// Удаление электронного метода оплаты
	function deleteepay() {
		$get=$this->f3->get('GET');
		$epays=new \Models\Epays($this->db, $this->f3);
		$res=$epays->delete_epay($get['id']);
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	function license() {
		$api=new \Models\Api($this->f3, null, null, null, null);
		$res=$this->model->check_end($api, $this->sets);
		if($res['success']) {
			$this->sets['license_end']=$res['license_end'];
		}
		$this->f3->set('base_settings', $this->sets);
		$this->f3->set('page_data', $this->model->page_data('renewlicense'));
	}

	function pricechecker() {
		$data=$this->f3->get('COOKIE.pricechecker_settings');
		$this->f3->set('data', json_decode($data, true));
		$this->f3->set('page_data', $this->model->page_data('pricechecker'));
	}

	function post_pricechecker(){
		$post=$this->f3->get('POST');
		$this->f3->set('COOKIE.pricechecker_settings', json_encode($post), 3600*24*365);
		$res['success']=true;
		$res['txt']=$this->messages->message('save_successful')['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	function ofd() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$data=$fr->get_ofd();
		$this->f3->set('data', $data);
		$this->f3->set('page_data', $this->model->page_data('ofd'));
	}

	function post_ofd() {
		$post=$this->f3->get('POST');
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$res=$fr->set_ofd($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function kkm_registration() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$this->f3->set('ofd_data', $fr->get_ofd());
		$data=$fr->get_regdata();
		$this->f3->set('op_mode', $fr->fr->op_mode);
		$this->f3->set('agent_tag', $fr->fr->agent_tag);
		$this->f3->set('ffd_version', $fr->fr->ffd_version);
		$this->f3->set('reg_data', $fr->fr->reg_data);
		$this->f3->set('why_105', $fr->fr->why_105);
		$this->f3->set('why_12', $fr->fr->why_12);
		$this->f3->set('because_12', $fr->fr->because_12);
		$this->f3->set('data', $data);
		$this->f3->set('page_data', $this->model->page_data('kkm_registration'));
	}

	function post_kkm_registration() {
		$post=$this->f3->get('POST');
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$res=$fr->kkm_registration($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function closefn() {
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$res=$fr->closefn($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function manualforprinters() {
		$this->f3->set('page_data', $this->model->page_data('manualforprinters'));
	}

	function checktoken() {
		$get=$this->f3->get('GET');
		if(!$get['token']) {
			$this->f3->set('page_data', $this->messages->message('not_enough_data'));
			return;
		}
		$this->sets['token_chz']=$get['token'];
		$chz=new \Models\Chz($this->db, $this->f3, $this->sets);
		$res=$chz->get_cdn();
		if($res['success']===true) {
			$this->f3->set('page_data', $this->messages->message('checktoken_success'));
			return;
		}
		if(isset($res['txt'])) {
			$this->f3->set('page_data', $this->messages->message($res['txt']));
			return;	
		}
		$page_data=$this->messages->message('checktoken_false');
		$page_data['txt'].' '.$res['code'];
		$this->f3->set('page_data', $page_data);
	}
}
