<?php
$db->exec("CREATE TABLE device_synchronization (id INTEGER PRIMARY KEY, serial_number TEXT, type TEXT, time VARCHAR DEFAULT '0')");
$db->exec("CREATE INDEX serial_number ON device_synchronization (serial_number)");
$db->exec("CREATE INDEX device_type ON device_synchronization (type)");
$db->exec("CREATE INDEX device_time ON device_synchronization (time)");
$db->exec("CREATE TABLE clients_scales (id INTEGER PRIMARY KEY, driver TEXT, title TEXT, active INTEGER DEFAULT (0), driver_config TEXT)");
$db->exec("CREATE INDEX clients_scales_active ON clients_scales (active)");

$db->exec("CREATE TABLE temp_table AS SELECT * FROM synchronization");
$db->exec("DROP TABLE synchronization");
$db->exec("CREATE TABLE synchronization (id INTEGER PRIMARY KEY, time_start VARCHAR, time_update VARCHAR, tickets_update VARCHAR, users_update VARCHAR, partners_update VARCHAR, partners_timer VARCHAR, auto_sinch INT, method INT, loyalty VARCHAR, fiscalization VARCHAR, logs VARCHAR DEFAULT '0', ordersstatuses VARCHAR DEFAULT '0', clients_scales VARCHAR DEFAULT '0')");
$db->exec("INSERT INTO synchronization (id, time_start, time_update, tickets_update, users_update, partners_update, partners_timer, auto_sinch, method, loyalty, fiscalization, logs, ordersstatuses) SELECT id, time_start, time_update, tickets_update, users_update, partners_update, partners_timer, auto_sinch, method, loyalty, fiscalization, logs, ordersstatuses FROM temp_table");
$db->exec("DROP TABLE temp_table");

$db->exec("CREATE TABLE temp_table AS SELECT * FROM products");
$db->exec("DROP TABLE products");
$db->exec("CREATE TABLE products (id INT PRIMARY KEY UNIQUE, code VARCHAR, ppr INT DEFAULT (1), fast INT DEFAULT (0), title VARCHAR, short_title VARCHAR, img TEXT, category_id INT, stock DOUBLE DEFAULT (0), price DOUBLE, buy_price DOUBLEDEFAULT (0), vat INT, vat_type INT, quantity DOUBLE DEFAULT (1), marking INT DEFAULT (0), marking_group VARCHAR DEFAULT '', egais INT DEFAULT (0), alcocode VARCHAR DEFAULT '', date_delete INT, date_update INT, print_group VARCHAR DEFAULT '', related TEXT DEFAULT '', max_discount DOUBLE DEFAULT (0), add_bonus INT DEFAULT (0), product_description TEXT DEFAULT '', stop INT DEFAULT (0), combo_data TEXT DEFAULT '', partner_id INT DEFAULT (0), units INT DEFAULT (0), sno VARCHAR DEFAULT '0', print_group_id INT DEFAULT (0), parent_id INT DEFAULT (0), multiple_sale INT DEFAULT (0), cocktail TEXT DEFAULT '', opt_price_1 DOUBLE DEFAULT (0), opt_price_2 DOUBLE DEFAULT (0), opt_price_3 DOUBLE DEFAULT (0), partner_type INT DEFAULT (5), other_data TEXT DEFAULT '', country_id INT DEFAULT (0), country_alpha2 VARCHAR DEFAULT '', gtd VARCHAR DEFAULT '', plu TEXT)");
$db->exec("INSERT INTO products (id, code, ppr, fast, title, short_title, img, category_id, stock, price, buy_price, vat, vat_type, quantity, marking, marking_group, egais, alcocode, date_delete, date_update, print_group, related, max_discount, add_bonus, product_description, stop, combo_data, partner_id, units, sno, print_group_id, parent_id, multiple_sale, cocktail, opt_price_1, opt_price_2, opt_price_3, partner_type, other_data, country_id, country_alpha2, gtd) SELECT id, code, ppr, fast, title, short_title, img, category_id, stock, price, buy_price, vat, vat_type, quantity, marking, marking_group, egais, alcocode, date_delete, date_update, print_group, related, max_discount, add_bonus, product_description, stop, combo_data, partner_id, units, sno, print_group_id, parent_id, multiple_sale, cocktail, opt_price_1, opt_price_2, opt_price_3, partner_type, other_data, country_id, country_alpha2, gtd FROM temp_table");
$db->exec("DROP TABLE temp_table");
$db->exec("CREATE INDEX category_id ON products (category_id)");
$db->exec("CREATE INDEX code ON products (code)");
$db->exec("CREATE INDEX date_delete ON products (date_delete)");
$db->exec("CREATE INDEX egais ON products (egais)");
$db->exec("CREATE INDEX id_prod ON products (id)");
$db->exec("CREATE INDEX marking ON products (marking)");
$db->exec("CREATE INDEX ppr ON products (ppr)");
$db->exec("CREATE INDEX products_parent_id ON products (parent_id)");
$db->exec("CREATE INDEX stop ON products (stop)");
$db->exec("CREATE INDEX title ON products (title)");
$db->exec("CREATE INDEX plu ON products (plu)");
