<?php
namespace Models;

// Модель для настроек
class Settings extends Controller {
	public $db, $f3;

	public $marktype=array(
		1=>array('title'=>'Товары легкой промышленности', 'required_check'=>'2024-11-01 00:00:00'),
		2=>array('title'=>'Обувные товары', 'required_check'=>'2024-11-01 00:00:00'),
		3=>array('title'=>'Табак и табачная продукция', 'required_check'=>'2024-04-01 00:00:00'),
		4=>array('title'=>'Духи и туалетная вода', 'required_check'=>'2024-11-01 00:00:00'),
		5=>array('title'=>'Шины и покрышки пневматические резиновые новые', 'required_check'=>'2024-11-01 00:00:00'),
		6=>array('title'=>'Фотокамеры (кроме кинокамер), фотовспышки и лампы-вспышки', 'required_check'=>'2024-11-01 00:00:00'),
		7=>array('title'=>'Медицинские изделия', 'required_check'=>'2024-11-01 00:00:00'),
		8=>array('title'=>'Молоко и молочная продукция', 'required_check'=>'2024-09-01 00:00:00'),
		9=>array('title'=>'Велосипеды и велосипедные рамы', 'required_check'=>'2025-03-01 00:00:00'),
		10=>array('title'=>'Кресла-коляски', 'required_check'=>'2025-03-01 00:00:00'),
		11=>array('title'=>'Шубы и меховые изделия', 'required_check'=>'2025-03-01 00:00:00'),
		12=>array('title'=>'Альтернативная табачная продукция', 'required_check'=>'2024-04-01 00:00:00'),
		13=>array('title'=>'Упакованная вода', 'required_check'=>'2024-09-01 00:00:00'),
		14=>array('title'=>'Соковая продукция и безалкогольные напитки', 'required_check'=>'2025-02-05 00:00:00'),
		15=>array('title'=>'Пиво и слабоалкогольные напитки', 'required_check'=>'2024-11-01 00:00:00'),
		16=>array('title'=>'Разливное пиво', 'required_check'=>'2024-04-01 00:00:00'),
		17=>array('title'=>'Лекарства', 'required_check'=>'2025-06-01 00:00:00'),
		18=>array('title'=>'Биологически активные добавки к пище', 'required_check'=>'2024-11-01 00:00:00'),
		19=>array('title'=>'Антисептики и дезинфицирующие средства', 'required_check'=>'2024-11-01 00:00:00'),
		20=>array('title'=>'Морепродукты (икры осетровых и лососевых)', 'required_check'=>'2025-10-01 00:00:00'),
		21=>array('title'=>'Корма для животных', 'required_check'=>'2026-03-01 00:00:00'),
		22=>array('title'=>'Безалкогольное пиво', 'required_check'=>'2025-10-01 00:00:00'),
		23=>array('title'=>'Пищевые растительные масла', 'required_check'=>'2026-05-01 00:00:00'),
		24=>array('title'=>'Лекарственные препараты для ветеринарного применения', 'required_check'=>'2025-09-01 00:00:00'),
		25=>array('title'=>'Технические средства реабилитации', 'required_check'=>'2025-10-01 00:00:00'),
		26=>array('title'=>'Консервированные продукты', 'required_check'=>'2027-04-01 00:00:00'),
		27=>array('title'=>'Снеки, соусы, специи, приправы, пряности, сухие бульоны, сухие супы и уксусы', 'required_check'=>'2026-10-01 00:00:00'),
		28=>array('title'=>'Парфюмерно-косметическая продукция и бытовая химия', 'required_check'=>'2026-06-01 00:00:00'),
		29=>array('title'=>'Отдельные виды смазочных материалов и специальных автомобильных жидкостей', 'required_check'=>'2026-04-01 00:00:00'),
	);

	public function __construct($f3, $db=null) {
		parent::__construct($f3);
		$this->db=$db;
		$this->f3=$f3;
	}

	// данные о страницах
	function page_data($page='api') {
		$pages=array(
			'start'=>array(
				'title'=>'Добро пожаловать',
				'inc'=>'settings_start.htm'
			),
			'api'=>array(
				'title'=>'Настройки подключения к API',
				'inc'=>'settings_api.htm'
			),
			'synchronization'=>array(
				'title'=>'Синхронизация с Агорта',
				'inc'=>'settings_synchronization.htm'
			),
			'kkm'=>array(
				'title'=>'Настройка Контрольно-кассовой машины',
				'inc'=>'settings_fr.htm'
			),
			'bankterminal'=>array(
				'title'=>'Настройка банковского терминала',
				'inc'=>'settings_bankterminal.htm'
			),
			'logs'=>array(
				'title'=>'Логи',
				'inc'=>'settings_logs.htm'
			),
			'cd'=>array(
				'title'=>'Настройка дисплея покупателя',
				'inc'=>'settings_cd.htm'
			),
			'service'=>array(
				'title'=>'Сервисное обслуживание',
				'inc'=>'settings_service.htm'
			),
			'base'=>array(
				'title'=>'Основные настройки',
				'inc'=>'settings_base.htm'
			),
			'kiosk'=>array(
				'title'=>'Настройки киоска',
				'inc'=>'settings_kiosk.htm'
			),
			'marking'=>array(
				'title'=>'Настройка работы с маркированными товарами и ЕГАИС',
				'inc'=>'settings_marking.htm'
			),
			'rooms'=>array(
				'title'=>'Управление залами',
				'inc'=>'settings_rooms.htm'
			),
			'drivers'=>array(
				'title'=>'Настройка драйвера',
				'inc'=>'settings_drivers.htm'
			),
			'driver_form'=>array(
				'title'=>'Настройка драйвера',
				'inc'=>'settings_drivers_form.htm'
			),
			'epay_drivers'=>array(
				'title'=>'Настройка драйвера',
				'inc'=>'settings_epay_drivers.htm'
			),
			'update_ticket_time'=>array(
				'title'=>'Изменить время выгрузки чеков',
				'inc'=>'settings_update_ticket_time.htm'
			),
			'scales'=>array(
				'title'=>'Настройка весов',
				'inc'=>'settings_scales.htm'
			),
			'kitchen_printer'=>array(
				'title'=>'Настройка принтера для кухни',
				'inc'=>'settings_kitchen_printer.htm'
			),
			'pre_printer'=>array(
				'title'=>'Настройка принтера для пречеков',
				'inc'=>'settings_pre_printer.htm'
			),
			'bar_printer'=>array(
				'title'=>'Настройка принтера для бара',
				'inc'=>'settings_bar_printer.htm'
			),
			'pricetags_printer'=>array(
				'title'=>'Настройка принтера для ценников',
				'inc'=>'settings_pricetags_printer.htm'
			),
			'autonomous'=>array(
				'title'=>'Настройка автономной работы',
				'inc'=>'settings_autonomous.htm'
			),
			'productcategories'=>array(
				'title'=>'Справочник категорий номенклатуры',
				'inc'=>'settings_productcategories.htm'
			),
			'devices'=>array(
				'title'=>'Настройка оборудования',
				'inc'=>'settings_devices.htm'
			),
			'epays'=>array(
				'title'=>'Электронные методы оплаты',
				'inc'=>'settings_epays.htm'
			),
			'scaner'=>array(
				'title'=>'Настройка сканера штрих-кодов',
				'inc'=>'settings_scaner.htm'
			),
			'renewlicense'=>array(
				'title'=>'Лицензия',
				'inc'=>'settings_renewlicense.htm'
			),
			'pricechecker'=>array(
				'title'=>'Настройки прайсчекера',
				'inc'=>'settings_pricechecker.htm'
			),
			'ofd'=>array(
				'title'=>'Настройки пфраметров ОФД и ОИСМ',
				'inc'=>'settings_ofd.htm'
			),
			'kkm_registration'=>array(
				'title'=>'Регистрация / Перерегистрация',
				'inc'=>'settings_kkm_registration.htm'
			),
			'manualforprinters'=>array(
				'title'=>'Команды и переменные чекопечатающего оборудования',
				'inc'=>'settings_manualforprinters.htm'
			),
			'clientsscales'=>array(
				'title'=>'Настройка весов самообслуживания',
				'inc'=>'settings_clientsscales.htm'
			),
		);
		$pages[$page]['page']=$page;

		return $pages[$page];
	}

	// Получаем настройки из таблицы настроек
	function get_settings($name=array()) {
		$sets=array();
		if($name) {
			$sql="SELECT * FROM `settings` WHERE ";
			$where='';
			$val=array();
			foreach ($name as $n) {
				if($where!='')$where.=' OR ';
				$where.="`name`=?";
				$val[]=$n;
			}
			if($where!='') {
				$s=$this->db->exec($sql.$where, $val);
				if($s) {
					foreach ($s as $val) {
						$sets[$val['name']]=$val['value'];
					}
				}
			}
		}
		return $sets;
	}

	// Получаем основные настройки программы
	function get_base() {
		$name=array(
			'auto_fullscreen',
			'virtual_keyboard',
			'descriptions_pattern',
			'cleaning',
			'auto_logout',
			'cafe_mode',
			'auto_fiscalization',
			'timezone',
			'check_mark',
			'check_expiration_date',
			'egais',
			'egais_chpok_mode',
			'url_egais',
			'fsrar_id',
			'org_name',
			'org_address',
			'inn',
			'kpp',
			'product_menu',
			'view_all_receipts',
			'lines_of_list',
			'modifiers_window',
			'dark_theme',
			'round_kop',
			'executor',
			'balance',
			'multikassa',
			'ip_range_start',
			'ip_range_end',
			'ip_port',
			'other_cashboxes',
			'autonomous',
			'send_orders',
			'orders_device',
			'orders_prefix',
			'auto_issued',
			'auto_sales_receipts',
			'animation',
			'ticket_description',
			'zoom',
			'kiosk_type',
			'kiosk_search',
			'kiosk_theme',
			'kiosk_title',
			'kiosk_logo',
			'kiosk_logo_height',
			'kiosk_title_size',
			'kiosk_receipt_print',
			'kiosk_scroll_button',
			'timeout_popup',
			'ticket_print_default',
			'show_product_img',
			'css',
			'gs1_symbols',
			'product_button_width',
			'partner_id',
			'license_key',
			'ping',
			'license_end',
			'table_size',
			'control_stock',
			'line_merge',
			'spill',
			'token_chz',
			'chz_cdn_update',
			'show_product_code',
			'orders_type',
			'default_partnergroup',
			'chz_alarm',
			'chz_offline',
			'chz_offline_url',
			'chz_offline_login',
			'chz_offline_pass',
			'egais_alarm',
			'egais_print_qr',
			'check_egais',
			'cd_logo_y',
			'cd_logo_x',
			'cd_time_advs_src',
			'check_double_mark',
			'planstock_day',
			'orders_day',
			'orders_alarm',
			'stop_list_order',
			'false_alarm',
			'success_alarm',
			'window_open_alarm',
			'error_click_alarm',
			'display_false_alarm',
			'show_error_executor_display',
			'piot_driver',
			'ip_clientsscales_range_start',
			'ip_clientsscales_range_end',
			'clients_search'
		);

		foreach($this->marktype as $n=>$data) {
			$name[]='required_check_'.$n;
		}

		$sets=$this->get_settings($name);
		$now=time();
		$sets['required_check_0']=1;
		foreach($this->marktype as $n=>$data) {
			if(strtotime($data['required_check'])<$now) {
				$sets['required_check_'.$n]=1;
			}
		}
		
		$sets['check_chz']=0;
		$sets['egais_chpok_mode']=1;

		if(!isset($sets['clients_search'])) $sets['clients_search']=0;
		if(!isset($sets['ip_clientsscales_range_start'])) $sets['ip_clientsscales_range_start']='127.0.0.1';
		if(!isset($sets['ip_clientsscales_range_end'])) $sets['ip_clientsscales_range_end']='127.0.0.255';
		if(!isset($sets['piot_driver'])) $sets['piot_driver']='';

		if(!isset($sets['show_product_compound'])) $sets['show_product_compound']=2;

		$sets['marktype']=$this->marktype;
		if(!isset($sets['display_false_alarm'])) {
			$sets['display_false_alarm']=1;
		}
		if(!isset($sets['false_alarm'])) {
			$sets['false_alarm']=1;
		}
		if(!isset($sets['success_alarm'])) {
			$sets['success_alarm']=1;
		}
		if(!isset($sets['window_open_alarm'])) {
			$sets['window_open_alarm']=1;
		}
		if(!isset($sets['error_click_alarm'])) {
			$sets['error_click_alarm']=1;
		}

		if(!$sets['default_partnergroup']) {
			$sets['default_partnergroup']=$this->f3->get('default_partnergroup');
		}
		if(!$sets['chz_cdn_update']) {
			$sets['chz_cdn_update']=0;
		}

		if(!$sets['chz_offline_login']) {
			$sets['chz_offline_login']='agorta';
		}

		if(!$sets['chz_offline_pass']) {
			$sets['chz_offline_pass']='agorta';
		}

		if($sets['other_cashboxes']) {
			$sets['other_cashboxes']=json_decode($sets['other_cashboxes'], true);
			$sets['other_cashboxes_ip']=array_keys($sets['other_cashboxes']);
		}
		else {
			$sets['other_cashboxes_ip']=array();
		}
		if(!$sets['gs1_symbols']) {
			$sets['gs1_symbols']='<GS>';
		}
		if(!$sets['product_button_width'] || $sets['product_button_width']<125) {
			$sets['product_button_width']=125;
		}
		if(!isset($sets['check_chz'])) {
			$sets['check_chz']=1;
		}
		if(!isset($sets['control_stock'])) {
			$sets['control_stock']=0;
		}
		if(!isset($sets['show_product_code'])) {
			$sets['show_product_code']=0;
		}
		if(!isset($sets['orders_type'])) {
			$sets['orders_type']=3;
		}
		if(!isset($sets['egais_alarm'])) {
			$sets['egais_alarm']=0;
		}
		if(!isset($sets['egais_print_qr'])) {
			$sets['egais_print_qr']=1;
		}
		if(!isset($sets['planstock_day'])) {
			$sets['planstock_day']=1;
		}
		if(!isset($sets['orders_day'])) {
			$sets['orders_day']=10;
		}
		if(!isset($sets['orders_alarm'])) {
			$sets['orders_alarm']=1;
		}
		if(!isset($sets['stop_list_order'])) {
			$sets['stop_list_order']=0;
		}
		if(!isset($sets['show_error_executor_display'])) {
			$sets['show_error_executor_display']=1;
		}

		$sets['auto_replacekey']=0;

		$sets['check_mrc']=2;

		if(!isset($sets['check_double_mark'])) $sets['check_double_mark']=2;
		if(!isset($sets['check_egais'])) $sets['check_egais']=0;

		if((int)$sets['autonomous']==1) {
			$sets['balance']=1;
		}

		if(!isset($sets['chz_offline'])) $sets['chz_offline']=0;
		if($sets['chz_offline']==0 && strtotime('2025-03-01T00:00:00')<time()) $sets['chz_offline']=1;
		if(!isset($sets['chz_offline_url']) || $sets['chz_offline_url']=='') $sets['chz_offline_url']='http://127.0.0.1:5995';

		if(isset($sets['chz_alarm']) && $sets['chz_alarm']<time() && $sets['chz_alarm']>0) {
			$sets['chz_alarm']=0;
			$this->db->exec("UPDATE settings SET value=0 WHERE name='chz_alarm'");
			$this->db->exec("UPDATE chz_cdn SET code=0, time_update=?", time());
		}

		if(!isset($sets['cd_logo_x'])) $sets['cd_logo_x']='right';
		if(!isset($sets['cd_logo_y'])) $sets['cd_logo_y']='bottom';
		if(!isset($sets['cd_time_advs_src'])) $sets['cd_time_advs_src']=30;

		$sets['round_kop']=0;

		return $sets;
	}

	// Сохраняем основные настройки программы
	function save_base($post) {
		if(isset($post['auto_logout']) && !is_numeric($post['auto_logout']) || $post['auto_logout']<0) {
			return array(
				'success'=>false,
				'txt'=>'incorrect_auto_logout'
			);
		}

		if(isset($post['chz_alarm']) && $post['chz_alarm']==1) {
			$post['chz_alarm']=time()+24*3600;
		}
		if(isset($post['chz_alarm']) && $post['chz_alarm']==0) {
			$this->db->exec("UPDATE chz_cdn SET code=0, time_update=?", time());
		}

		if(isset($post['egais']) && $post['egais']>0) {
			if($post['url_egais']=='') {
				return array(
					'success'=>false,
					'txt'=>'incorrect_egais_url'
				);
			}

			if($post['fsrar_id']=='') {
				return array(
					'success'=>false,
					'txt'=>'input_organization_information'
				);
			}
		}

		if($post['chz_offline']==1) {
			if($post['chz_offline_url']=='') {
				return array(
					'success'=>false,
					'txt'=>'input_chz_offline_url'
				);
			}
			if($post['chz_offline_login']=='') {
				return array(
					'success'=>false,
					'txt'=>'input_chz_offline_login'
				);
			}
			if($post['chz_offline_pass']=='') {
				return array(
					'success'=>false,
					'txt'=>'input_chz_offline_pass'
				);
			}
		}

		$sql="INSERT OR REPLACE INTO `settings` (`name`, `value`) VALUES ";
		$val=array();
		foreach ($post as $key => $value) {
			if(!empty($val)) {
				$sql.=", ";
			}
			$sql.="(?, ?)";
			$val[]=$key;
			$val[]=$value;
		}
		$res=$this->db->exec($sql, $val);
		if($res!==false) {
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'reload_menu'=>true
			);
		}
		return array(
			'success'=>false,
			'txt'=>'db_error'
		);
	}

	// Сохранаяем настройки киоска
	function save_kiosk($post) {
		$sql="INSERT OR REPLACE INTO `settings` (`name`, `value`) VALUES ";
		$val=array();
		foreach ($post as $key => $value) {
			if(!empty($val)) {
				$sql.=", ";
			}
			$sql.="(?, ?)";
			$val[]=$key;
			$val[]=$value;
		}
		$res=$this->db->exec($sql, $val);
		if($res!==false) {
			return array(
				'success'=>true,
				'txt'=>'save_successful'
			);
		}
		return array(
			'success'=>false,
			'txt'=>'db_error'
		);
	}

	// Создаем файл настройек API
	function create_config_api($data) {
		$txt="<?php\r\n";
		$txt.='$api_store_id="'.$data['store_id'].'";'."\n\r";
		$txt.='$api_rm_id="'.$data['rm_id'].'";'."\n\r";
		$txt.='$api_rm_name="'.$data['rm_name'].'";'."\n\r";
		$txt.='$api_domen="'.$data['domen'].'";'."\n\r";
		$txt.='$api_pass="'.$data['pass'].'";'."\n\r";
		$txt.='$api_count="'.$data['count'].'";'."\n\r";
		$this->f3->write('app/api_config.php', $txt);
	}
	
	// Сохраняем настройки API
	function post_api($post) {
		if(!$post['domen'] || !$post['pass'] || !$post['store_id'] || !$post['rm_id'] || !$post['rm_name'] || !$post['count']) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$post['domen']=mb_strtolower($post['domen']);

		if(!$post['old_rm_id'] || ($post['old_rm_id'] && $post['old_rm_id']!=$post['rm_id'])) {
			$api=new \Models\Api($this->f3, $post['domen'], $post['pass'], $post['store_id'], $post['count']);
			$res=$api->uniqcashbox($post['store_id'], $post['rm_id']);
			if(!$res['success']) {
				$txt='';
				$m=new \Models\Messages();
				foreach ($res['error'] as $er) {
					$txt.=$m->message($er)['txt'].'<br>';
				}
				return array(
					'success'=>false,
					'txt'=>$txt,
					'debug'=>$res['debug']
				);
			}
		}
		if($post['old_rm_id'] && $post['old_rm_id']!=$post['rm_id']) {
			$this->db->exec("UPDATE cd_settings SET rm=? WHERE rm=?", array($post['rm_id'], $post['old_rm_id']));
			$this->db->exec("UPDATE fr_settings SET rm=? WHERE rm=?", array($post['rm_id'], $post['old_rm_id']));
			$this->db->exec("UPDATE scales_settings SET rm=? WHERE rm=?", array($post['rm_id'], $post['old_rm_id']));
			$this->db->exec("UPDATE changes SET rm=? WHERE rm=?", array($post['rm_id'], $post['old_rm_id']));
			$this->db->exec("UPDATE receipts SET rm=? WHERE rm=?", array($post['rm_id'], $post['old_rm_id']));
		}
		if($post['old_rm_id']) {
			$this->db->exec("UPDATE fr_settings SET rm_name=? WHERE rm=?", array($post['rm_name'], $post['rm_id']));
		}
		$this->create_config_api($post);
		$res=array(
			'success'=>true,
			'txt'=>'save_successful',
			'reroute'=>'/'
		);

		if($this->f3->get('authorization_user')) {
			unset($res['reroute']);
		}
		return $res;
	}

	// Сохраняем настройки автономного режима
	function save_autonomous($data) {
		$error=0;
		if($data['autonomous']) {
			$res=$this->db->exec("UPDATE fr_settings SET rm=?, sno=? WHERE rm=?", array((string)$data['rm_id'], $data['sno'], $data['old_rm_id']));
			if($res===false) {
				$error++;
			}
			$res=$this->db->exec("UPDATE cd_settings SET rm=? WHERE rm=?", array((string)$data['rm_id'], $data['old_rm_id']));
			if($res===false) {
				$error++;
			}
			$res=$this->db->exec("UPDATE scales_settings SET rm=? WHERE rm=?", array((string)$data['rm_id'], $data['old_rm_id']));
			if($res===false) {
				$error++;
			}
			foreach ($data['barcodes_pr_api'] as $name => $value) {
				$sql[]="INSERT OR REPLACE INTO settings (name, value) VALUES (?, ?)";
				$val[]=array($name, $value);
			}
		}
		$sql[]="INSERT OR REPLACE INTO settings (name, value) VALUES (?, ?)";
		$val[]=array('autonomous', $data['autonomous']);
		$res=$this->db->exec($sql, $val);
		if($res===false) {
			$error++;
		}
		if($error>0) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload_menu'=>true
		);
	}

	// Сохраняем настройки автосинхронизации
	function post_synchronization($db,$auto_sinch) {
		$res=$db->exec("UPDATE synchronization SET auto_sinch=?", $auto_sinch);
		if($res>=0) {
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'reload'=>'.auto_sinch_info',
				'close_all_window'=>true
			);
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
	}

	// сброс всех настроек и удаление базы данных
	function reset() {
		if(!@unlink('app/api_config.php')) {
			return array(
				'success'=>false,
				'txt'=>'file_is_not_delete'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reroute'=>'/'
		);
	}

	// Удаление старых чеков
	function cleaning() {
		// Узнаем чеки для удаления и формируем данные для запроса удаления строк
		$sql="SELECT id FROM `receipts` WHERE time<=? AND time>0";
		$time=time()-3600*24*$this->f3->get('cleaning_day');
		$tickets=$this->db->exec($sql, $time);
		$in='';
		$val=array();
		if($tickets) {
			foreach ($tickets as $n=>$t) {
				if($in!='')$in.=', ';
				$in.='?';
				$val[]=$t['id'];
				if($n>0 && $n%100==0) {
					$sql="DELETE FROM `receipts` WHERE `id` IN (".$in.")";
					if($this->db->exec($sql, $val)!==false) {
						$sql="DELETE FROM `receiptlines` WHERE `receipt_id` IN (".$in.")";
						$this->db->exec($sql, $val);
						$in='';
						$val=array();
					}
				}
			}
		}
		$this->save_base(array('cleaning'=>time()));
		$this->db->exec("VACUUM");
	}

	// Сохраненеи настроек драйвера
	function save_driver($data) {
		$file=$data['path'].'/server.config';
		if(!file_exists($file)) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}
		// Сохранение изначального файла настроек, при первом изменении
		$file_default=$file.'.default';
		if(!file_exists($file_default)) {
			copy($file, $file_default);
		}
		if($data['device']!='pre' && $data['device']!='kitchen' && $data['device']!='bar' && $data['device']!='pricetags') {
			$data['device']='';
		}
		if($data['device']!='') {
			if($data['print_group_id']!='') {
				$file=$data['path'].'/'.$data['device'].'_'.$data['print_group_id'].'_server.config';
			}
			else {
				$file=$data['path'].'/'.$data['device'].'_server.config';
			}
			if(!file_exists($file_default)) {
				copy($file_default, $file);
			}
		}
		if(file_put_contents($file, $data['txt'])) {
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'close_all_window'=>true
			);
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'error'
			);
		}
	}

	// получаем настройки драйвера из БД
	function get_driver_config($path, $device='kkm', $print_group_id=0, $default=0) {
		$file=$path.'/driver.config';
		$server_config=array();
		$values=array();
		if($device!='epay') {
			if(file_exists($path.'/server.config')) {
				$server_config=parse_ini_file($path.'/server.config');
			}
			if($print_group_id>0 && file_exists($path.'/'.$device.'_'.$print_group_id.'_server.config')) {
				$server_config=parse_ini_file($path.'/'.$device.'_'.$print_group_id.'_server.config');
			}
			if(file_exists($path.'/'.$device.'_server.config')) {
				$server_config=parse_ini_file($path.'/'.$device.'_server.config');
			}
			if(empty($server_config)) {
				if(file_exists($path.'/server.config.bak')) {
					$server_config=parse_ini_file($path.'/server.config.bak');
				}
				if($print_group_id>0 && file_exists($path.'/'.$device.'_'.$print_group_id.'_server.config.bak')) {
					$server_config=parse_ini_file($path.'/'.$device.'_'.$print_group_id.'_server.config.bak');
				}
				if(file_exists($path.'/'.$device.'_server.config.bak')) {
					$server_config=parse_ini_file($path.'/'.$device.'_server.config.bak');
				}
			}
		}
		else {
			$epay_config=$this->db->exec("SELECT driver_config FROM epays_settings WHERE driver=? LIMIT 1", array($path));
			$server_config=array();
			if($epay_config[0]['driver_config']) {
				$server_config=parse_ini_string($epay_config[0]['driver_config']);
			}
			if(file_exists($path.'/server.config')) {
				$server_config_default=parse_ini_file($path.'/server.config');
				$server_config=array_merge($server_config_default, $server_config);
			}
		}
		if(!file_exists($file)) {
			return array('config'=>$server_config);
		}
		$config=parse_ini_file($file);
		if($default==0) {
			$values=$this->db->exec("SELECT name, value FROM driver_settings WHERE path=? AND device=? AND print_group_id=?", array($path, $device, $print_group_id));
			if(!empty($values)) {
				$values=array_combine(array_column($values, 'name'), array_column($values, 'value'));
			}
			elseif(!empty($server_config)) {
				$values=$server_config;
			}
		}
		foreach($config['params'] as $n=>$key) {
			if(isset($config[$key]['device'])) {
				$devices=explode(',', $config[$key]['device']);
				if(!in_array($device, $devices)) {
					unset($config[$key]);
				}
			}
			if(!isset($config[$key]['default'])) continue;
			if(isset($values[$key])) {
				$config[$key]['default']=$values[$key];
			}
			elseif(!isset($config[$key]['default']) && isset($server_config[$key])) {
				$config[$key]['default']=$server_config[$key];
			}

			if(isset($config[$key]['type']) && $config[$key]['type']=='select' && isset($config[$key]['options'])) {
				$config[$key]['options']=json_decode($config[$key]['options'], true);
			}

			$value=$config[$key]['default'];
			if($value=='true') $value=true;
			elseif($value=='false') $value=false;
			if(isset($config[$key]['type']) && $config[$key]['type']=='textarea') {
				if(!is_array($value))$value=array_filter(explode("\n", $value));
			}

			if(isset($config[$key]['group'])) {
				$config['config'][$config[$key]['group']][$key]=$v;
			}
			else {
				$config['config'][$key]=$value;
			}
		}

		return $config;
	}

	// Сохраняем настройки драйвера из визуальной формы
	function save_driver_form($data) {
		if(!isset($data['device']) || $data['device']=='') $data['device']='kkm';
		if(!isset($data['print_group_id']) || $data['print_group_id']=='') $data['print_group_id']=0;
		$success=true;
		foreach($data['params'] as $key=>$value) {
			$val=array(
				$data['path'],
				$data['device'],
				$data['print_group_id'],
				$key,
				$value
			);
			$res=$this->db->exec("INSERT OR REPLACE INTO driver_settings (path, device, print_group_id, name, value) VALUES (?, ?, ?, ?, ?)", $val);
			if($res===false) {
				$success=false;
			}
		}
		if($data['device']=='epay' && isset($data['id'])) {
			$this->db->exec("UPDATE epays_settings SET driver_config=? WHERE id=?", array($data['print_group_id'], $data['id']));
		}
		if($success==true) {
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'close_all_window'=>true
			);
		}
		return array(
			'success'=>false,
			'txt'=>'db_error'
		);
	}

	// Запуск драйвера
	function start_driver($driver) {
		$script=$driver.'/server.py';
		$folders=explode('/', $driver);
		if(!file_exists($script)) {// Если файла нет, то это нативный драйвер
			if($folders[1]=='printers') {
				$sets=$this->db->exec("SELECT * FROM  `fr_settings` LIMIT 1")[0];
			}
			else {
				$sets=$this->db->exec("SELECT * FROM  `cd_settings` LIMIT 1")[0];
			}
			$sets['driver']=$driver;
			return $this->start_driver_php($sets);
			/*return array(
				'success'=>false,
				'txt'=>'not_found'
			);*/
		}
		include('drivers/start.php');

		// Проверяем запуск драйвера
		$models=array(
			'printers'=>'\Models\Fr',
			'displays'=>'\Models\Cd'
		);
		$m=new $models[$folders[1]]($this->db, $this->f3);
		//$m->test($driver);

		return array(
			'success'=>true,
			'txt'=>'success'
		);
	}

	function start_driver_php($sets, $device='kkm') {
		$script=$sets['driver'].'/server.php';
		if($device=='kitchen' || $device=='pre' || $device=='bar' || $device=='pricetags') {
			$script=$sets['driver'].'/'.$device.'server.php';
		}
		if(!file_exists($script)) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}

		$folders=explode('/', $sets['driver']);
		if($folders[1]=='printers') {
			include($sets['driver'].'/server.php');
			$class=array_reverse($folders)[0];
			$fr_model='\Models\\'.$class.'_Fr_php';
			$config_file='/server.config';
			if($device=='pre' || $device=='kitchen' || $device=='bar' || $device=='pricetags') {
				if(file_exists($sets['driver'].'/'.$device.'_'.$sets['print_group_id'].'_server.config')) {
					$config_file='/'.$device.'_'.$sets['print_group_id'].'_server.config';
				}
				elseif(file_exists($sets['driver'].'/'.$device.'_server.config')) {
					$config_file='/'.$device.'_server.config';
				}
			}
			$config=parse_ini_file($sets['driver'].$config_file);
			$m=new $fr_model($this->f3, $sets, $config);
			$m->kkm_init();
		}
		else {
			if(!class_exists('Models\Cd_php', false)) {
				include($sets['driver'].'/server.php');
			}
			$m=new Cd_php($this->f3, $sets);
			$m->cd_init();
		}
		return array(
			'success'=>true,
			'txt'=>'success'
		);
	}

	// Сохранение изменения времени выгрузки чеков
	function save_ticket_time($db, $data) {
		$data=strtotime($data);
		if(!is_numeric($data)) {
			return array(
				'success'=>false,
				'txt'=>'incorrect_data'
			);
		}
		$res=$db->exec("UPDATE receipts SET synch=0 WHERE synch=1 AND time>=?", $data);
		if($res!==false) {
			$res=$db->exec("UPDATE synchronization SET tickets_update=?", $data);
			if($res!==false) {
				return array(
					'success'=>true,
					'txt'=>'save_successful',
					'reload'=>'.ticket_time',
					'close_all_window'=>true
				);
			}
		}
		return array(
			'success'=>false,
			'txt'=>'db_error'
		);
	}
	
	function get_timezones() {
		$timezones=array(
			'Europe/Kaliningrad'=>'Калининград (МСК -1)',
			'Europe/Moscow'=>'Москва (МСК)',
			'Europe/Kirov'=>'Киров (МСК)',
			'Europe/Simferopol'=>'Симферополь (МСК)',
			'Europe/Volgograd'=>'Волгоград (МСК)',
			'Europe/Ulyanovsk'=>'Ульяновск (МСК +1)',
			'Europe/Saratov'=>'Саратов (МСК +1)',
			'Europe/Samara'=>'Самара (МСК +1)',
			'Asia/Yekaterinburg'=>'Екатеринбург (МСК +2)',
			'Asia/Omsk'=>'Омск (МСК +3)',
			'Europe/Astrakhan'=>'Астрахань (МСК +4)',
			'Asia/Barnaul'=>'Барнаул (МСК +4)',
			'Asia/Krasnoyarsk'=>'Красноярск (МСК +4)',
			'Asia/Novokuznetsk'=>'Новокузнецк (МСК +4)',
			'Asia/Tomsk'=>'Томск (МСК +4)',
			'Asia/Novosibirsk'=>'Новосибирск (МСК +4)',
			'Asia/Irkutsk'=>'Иркутск (МСК +5)',
			'Asia/Chita'=>'Чита (МСК +6)',
			'Asia/Yakutsk'=>'Якутск (МСК +6)',
			'Asia/Ust-Nera'=>'Усть-Нера (МСК +7)',
			'Asia/Vladivostok'=>'Владивосток (МСК +7)',
			'Asia/Magadan'=>'Магадан (МСК +8)',
			'Asia/Sakhalin'=>'Сахалин (МСК +8)',
			'Asia/Srednekolymsk'=>'Среднеколымск (МСК +8)',
			'Asia/Anadyr'=>'Анадырь (МСК +9)',
			'Asia/Kamchatka'=>'Камчатка (МСК +9)'
		);
		$month=date('n');
		$day=date('j');

		$StalingradBattleStart=strtotime(date('Y').'-8-23');
		$StalingradBattleEnd=strtotime(date('Y').'-2-2');
		$may9=strtotime(date('Y').'-5-9');
		$day5=3600*24*5;
		$now=time();

		if(($now>$StalingradBattleStart-$day5 && $now<$StalingradBatleStart+$day5) || ($now>$StalingradBattleEnd-$day5 && $now<$StalingradBattleEnd+$day5) || ($now>$may9-$day5 && $now<$may9+$day5)) {
			$timezones['Europe/Volgograd']='Сталинград (МСК)';
		}

		return $timezones;
	}

	function get_themes() {
		foreach (glob($this->f3->get('ROOT')."/ui/css/shop_themes/*.css") as $file) {
			$f=array_reverse(explode('/', $file));
			$css=mb_substr($f[0], 0, mb_strrpos($f[0], '.css'));
			$themes[$css]=ucwords(str_replace('-', ' ', $css));
		}
		return $themes;
	}

	function get_kiosk_types() {
		$types=array();
		foreach (glob($this->f3->get('ROOT')."/ui/kiosk/*", GLOB_ONLYDIR) as $path) {
			$dir=array_reverse(explode('/', $path));
			$config=parse_ini_file($path.'/config.ini');
			$types[$dir[0]]=$config;
		}
		return $types;
	}

	function check_end($api, $sets) {
		$res=$api->check_end($sets);
		if($res['success']) {
			$data=array(
				'license_end'=>$res['license_end']
			);
			$res=$this->save_base($data);
			if($res['success']) {
				$res['license_end']=$data['license_end'];
			}
		}
		return $res;
	}

	function ping($request=1) {
		$sets=$this->get_base();
		$now=time();
		// Если не надо делать внешних запросов, то просто проверим состояние лицензии в автономном режиме
		// Для облачной кассы ничего не надо делать, все произойдет отдельным запросом пинга
		// Нормальная работа облачной кассы зависит от баланса, который проверяется при синхронизации
		if($request==0) {
			if((int)$sets['autonomous']==1) {
				// Если еще нет данных о лицензии, значит еще не было пинга с запросом лицензии, считаем что все в порядке
				if(!isset($sets['license_key'])) {
					return array(
						'success'=>true
					);
				}
				if($sets['ping']>$now-24*3600 && $sets['license_end']>$now) {
					return array(
						'success'=>true
					);
				}
				if($sets['license_end']<$now && $sets['license_end']>0) {
					return array(
						'success'=>false,
						'txt'=>'license_has_expired'
					);
				}
			}

			return array(
				'success'=>true
			);
		}

		$api=new \Models\Api($this->f3, null, null, null, null);
		if((int)$sets['autonomous']==1) {
			if(!isset($sets['license_key'])) {
				if($sets['partner_id']) {
					$partner=array(
						$sets['partner_id']
					);
				}
				else {
					$partner=array();
				}
				$license=$api->gen_license($partner);
				if(!$license['success']) {
					return $license;
				}
				$data=array(
					'license_key'=>$license['key'],
					'license_end'=>0,
					'ping'=>0
				);
				$res=$this->save_base($data);
				if(!$res['success']) {
					return $res;
				}
				$sets['license_key']=$license['key'];
				$sets['license_end']=0;
				$sets['ping']=0;
			}
		}
		else {
			$api_data=$this->f3->get('api_data');
			$domen=explode('.', $api_data['domen']);
			$sets['domen']=$domen[0];
			$sets['license_end']=$now+3600*24*7;
		}

		if($sets['ping']>$now-24*3600 && $sets['license_end']>$now) {
			return array(
				'success'=>true
			);
		}
		if($sets['license_end']<$now && $sets['license_end']>0) {
			$res=$this->check_end($api, $sets);
			if($res['success']) {
				return $res;
			}
			return array(
				'success'=>false,
				'txt'=>'license_has_expired'
			);
		}

		$receipt=$this->db->exec("SELECT * FROM receipts WHERE (fd!='' OR fp!='') AND sum>0 AND time>0 ORDER BY time DESC LIMIT 1");

		$org_data=array(
			'ККМ'=>'kkm',
			'ФФД'=>'ffd',
			'Адрес'=>'org_address',
			'Наименование'=>'org_name',
			'ИНН'=>'inn',
			'КПП'=>'kpp',
			'Сообщений для ОФД'=>'ofd_n',
			'Дата окончания ФН'=>'fn_end'
		);
		//$other_data=$this->get_settings($org_data);
		$other_data_txt='';
		$this->f3->set('fr_error_ignore', 1);
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', true);
		$other_data=array();
		if($fr->sets['active']) {
			$res=$fr->check_fnstatus();
			if($res['success']) {
				$other_data['version']=$this->f3->get('site_version');
				if(is_numeric($res['fn_end']) && (int)$res['fn_end']>0) {
					$res['fn_end']=date('d.m.Y', (int)$res['fn_end']);
				}
				elseif($res['fn_end']=='') {
					$res['fn_end']='нет данных';
				}
				foreach($org_data as $title=>$key) {
					if(isset($res[$key])) {
						$other_data[$key]=$res[$key];
					}
				}
				$other_data_txt=json_encode($other_data);
			}
			else {
				$other_data_txt='Не удалось получить данные';
			}
		}
		else {
			$other_data_txt='Работа с ККМ не настроена';
		}

		$res=$api->ping($sets, $receipt[0], $other_data_txt);
		if($res['debug'] && $sets['license_end']>$now) {
			return array(
				'success'=>true
			);
		}
		else {
			$data=array(
				'ping'=>$res['ping']??time(),
				'license_end'=>$res['license_end']??$sets['license_end']
			);
		}
		$this->save_base($data);
		return $res;
	}

	function driversgetoptions($data) {
		require_once($data['path'].'/server.php');
		$class=explode('/', $data['path']);
		$class=array_reverse($class);
		$model='\Models\\'.$class[0].'::'.$data['options_method'];
		return $model($data['params']);
	}
}
